#include "playbackvideoselectionwindow.h"
#include "videoselectiondelegate.h"

PlaybackVideoSelectionWindow::PlaybackVideoSelectionWindow(Session *session, const QString &text, const char* slot, QWidget *parent) :
    QWidget(parent),
    m_session(session),
    m_listView(new ListView(this)),
    m_editBar(new QMaemo5EditBar(tr("Select videos"), this)),
    m_acceptButton(new QPushButton(text, this)),
    m_vbox(new QVBoxLayout(this))
{
    setWindowFlags(Qt::Window);
    setWindowState(Qt::WindowFullScreen);
    setAttribute(Qt::WA_Maemo5StackedWindow, true);
    setAttribute(Qt::WA_DeleteOnClose, true);

    m_listView->setModel(m_session->playbackQueue());
    m_listView->setItemDelegate(new VideoSelectionDelegate(m_listView));
    m_editBar->addButton(m_acceptButton);

    m_vbox->setContentsMargins(0, 0, 0, 0);
    m_vbox->addWidget(m_editBar);
    m_vbox->addWidget(m_listView);

    connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    connect(m_acceptButton, SIGNAL(clicked()), this, SLOT(onButtonClicked()));
    connect(this, SIGNAL(accepted()), this, slot);
}

PlaybackVideoSelectionWindow::~PlaybackVideoSelectionWindow() {
    if (m_session->playbackQueue()->itemsChecked()) {
        m_session->playbackQueue()->checkNone();
    }
}

void PlaybackVideoSelectionWindow::positionAtIndex(const QModelIndex &index) {
    m_listView->scrollTo(index, QListView::PositionAtTop);
}

void PlaybackVideoSelectionWindow::onItemClicked(const QModelIndex &index) {
    m_session->playbackQueue()->toggleChecked(index.row());
}

void PlaybackVideoSelectionWindow::onButtonClicked() {
    if (m_session->playbackQueue()->itemsChecked()) {
        emit accepted();
    }
}

void PlaybackVideoSelectionWindow::addVideoDownloads() {
    m_session->transferManager()->addDownloadTransfers(m_session->playbackQueue()->checkedItems());
    m_session->playbackQueue()->checkNone();
}

void PlaybackVideoSelectionWindow::addAudioDownloads() {
    m_session->transferManager()->addDownloadTransfers(m_session->playbackQueue()->checkedItems(), true);
    m_session->playbackQueue()->checkNone();
}

void PlaybackVideoSelectionWindow::removeVideos() {
    m_session->playbackQueue()->removeVideos();
    m_session->playbackQueue()->checkNone();
}
