#include "listview.h"
#include <QScrollBar>

ListView::ListView(QWidget *parent) :
    QListView(parent),
    m_kineticScroller(property("kineticScroller").value<QAbstractKineticScroller *>()),
    m_minimum(0),
    m_maximum(1000000)
{
    setUniformItemSizes(true);
    setAutoScroll(false);
    setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setContextMenuPolicy(Qt::CustomContextMenu);

    connect(verticalScrollBar(), SIGNAL(rangeChanged(int,int)), this, SLOT(setScrollRange(int,int)));
    connect(verticalScrollBar(), SIGNAL(valueChanged(int)), this, SLOT(onScrollPositionChanged(int)));
}

void ListView::setScrollRange(int minimum, int maximum) {
    m_minimum = minimum;
    m_maximum = maximum;
}

void ListView::onScrollPositionChanged(int position) {
    if (position == m_maximum) {
        emit atEnd();
    }
}

void ListView::positionAtBeginning() {
    scrollTo(indexAt(QPoint(0, 0)), QListView::PositionAtTop);
}

void ListView::keyPressEvent(QKeyEvent *event) {
    if (event->key() == Qt::Key_Down) {
        m_kineticScroller->scrollTo(QPoint(0, rectForIndex(indexAt(QPoint(0, height()))).y()));
        event->accept();
    }
    else if (event->key() == Qt::Key_Up) {
        m_kineticScroller->scrollTo(QPoint(0, rectForIndex(indexAt(QPoint(0, -height()))).y()));
        event->accept();
    }
    else {
        event->ignore();
    }
}

void ListView::mousePressEvent(QMouseEvent *event) {
    setCurrentIndex(indexAt(event->pos()));
    QListView::mousePressEvent(event);
}

void ListView::mouseReleaseEvent(QMouseEvent *event) {
    QListView::mouseReleaseEvent(event);
    setCurrentIndex(QModelIndex());
}
