#include "groupitem.h"
#include "utils.h"

GroupItem::GroupItem(const QVariantMap &group, QObject *parent) :
    QObject(parent),
    m_id(group.value("id").toString()),
    m_title(group.value("name").toString()),
    m_artist(group.value("owner.username").toString()),
    m_artistId(group.value("owner.id").toString()),
    m_artistAvatarUrl(group.value("owner.avatar_medium_url").toString()),
    m_description(group.value("description").toString()),
    m_date(Utils::dateFromSecs(group.value("created_time").toLongLong())),
    m_member(false)
{
}
