#ifndef DAILYMOTIONVIDEOCOMMENTSTAB_H
#define DAILYMOTIONVIDEOCOMMENTSTAB_H

#include "abstracttab.h"
#include "session.h"
#include "videoitem.h"
#include "dailymotioncommentlistmodel.h"
#include "listview.h"
#include <QAction>
#include <QLabel>
#include <QGridLayout>

class DailymotionVideoCommentsTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit DailymotionVideoCommentsTab(Session *session, QSharedPointer<VideoItem> video, QWidget *parent);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged();
    void showCommentDialog();
    void showUserChannel(const QModelIndex &index);

private:
    Session *m_session;
    QSharedPointer<VideoItem> m_video;
    DailymotionCommentListModel *m_model;
    ListView *m_listView;
    QAction *m_commentAction;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // DAILYMOTIONVIDEOCOMMENTSTAB_H
