#ifndef TRANSFERDETAILSDIALOG_H
#define TRANSFERDETAILSDIALOG_H

#include "abstractdialog.h"
#include "../base/transferitem.h"

class TransferPrioritySelector;
class ConnectionsSelector;
class SubtitlesSelector;
class QLabel;
class QLineEdit;
class QGridLayout;
class QCheckBox;

class TransferDetailsDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit TransferDetailsDialog(QSharedPointer<TransferItem> transfer, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onTransferStatusChanged(Transfers::Status status);
    void onTransferSizeChanged(qint64 size);
    void onTransferProgressChanged(int progress);
    void onTransferSpeedChanged(int speed);
    void onFileNameTextChanged(const QString &text);
    void setTransferFileName();
    void onPauseResumeClicked();

private:
    QSharedPointer<TransferItem> m_transfer;
    QLabel *m_titleHeader;
    QLabel *m_statusHeader;
    QLabel *m_sizeHeader;
    QLabel *m_progressHeader;
    QLabel *m_statusLabel;
    QLabel *m_statusIcon;
    QLabel *m_sizeLabel;
    QLabel *m_progressLabel;
    QLabel *m_speedLabel;
    ConnectionsSelector *m_connectionsSelector;
    TransferPrioritySelector *m_prioritySelector;
    SubtitlesSelector *m_subtitlesSelector;
    QCheckBox *m_subtitlesCheckbox;
    QCheckBox *m_audioCheckbox;
    QLineEdit *m_nameEdit;
    QPushButton *m_nameButton;
    QPushButton *m_pauseResumeButton;
    QPushButton *m_cancelButton;
    QGridLayout *m_grid;
};

#endif // TRANSFERDETAILSDIALOG_H
