#ifndef TransferListModel_H
#define TransferListModel_H

#include "../base/transferitem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

class TransferListModel : public QAbstractListModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit TransferListModel(QObject *parent = 0);
    ~TransferListModel();

    int rowCount(const QModelIndex &parent = QModelIndex()) const;

    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;

    bool setData(const QModelIndex &index, const QVariant &value, int role);
    Q_INVOKABLE bool setData(int row, const QVariant &value, const QByteArray &role);

    QSharedPointer<TransferItem> get(int row) const;
#ifdef QML_USER_INTERFACE
    Q_INVOKABLE TransferItem* getFromQML(int row) const;
#endif

private:
    int indexOf(TransferItem *transfer) const;

private slots:
    void onTransferDataChanged();
    void onTotalTransfersChanged();

signals:
    void countChanged(int count);
};

#endif // TransferListModel_H
