#include "transferlistmodel.h"
#include "../base/transfermanager.h"
#ifdef QML_USER_INTERFACE
#include <QDeclarativeEngine>
#endif

TransferListModel::TransferListModel(QObject *parent) :
    QAbstractListModel(parent)
{
    QHash<int, QByteArray> roles;
    roles[TransferItem::TitleRole] = "title";
    roles[TransferItem::FileNameRole] = "fileName";
    roles[TransferItem::ThumbnailUrlRole] = "thumbnailUrl";
    roles[TransferItem::TransferTypeRole] = "transferType";
    roles[TransferItem::TransferTypeStringRole] = "transferTypeString";
    roles[TransferItem::ServiceRole] = "service";
    roles[TransferItem::ServiceStringRole] = "serviceString";
    roles[TransferItem::StatusRole] = "status";
    roles[TransferItem::StatusStringRole] = "statusString";
    roles[TransferItem::PriorityRole] = "priority";
    roles[TransferItem::PriorityStringRole] = "priorityString";
    roles[TransferItem::SizeRole] = "size";
    roles[TransferItem::PositionRole] = "position";
    roles[TransferItem::ProgressRole] = "progress";
    roles[TransferItem::ConvertibleToAudioRole] = "convertibleToAudio";
    roles[TransferItem::ConvertToAudioRole] = "saveAsAudio";
    roles[TransferItem::DownloadSubtitlesRole] = "downloadSubtitles";
    roles[TransferItem::SubtitlesLanguageRole] = "subtitlesLanguage";
    roles[TransferItem::PreferredConnectionsRole] = "preferredConnections";
    roles[TransferItem::MaximumConnectionsRole] = "maximumConnections";
    roles[TransferItem::IdRole] = "id";
    roles[TransferItem::VideoIdRole] = "videoId";
    this->setRoleNames(roles);

    for (int i = 0; i < TransferManager::instance()->totalTransfers(); i++) {
        if (QSharedPointer<TransferItem> transfer = TransferManager::instance()->get(i)) {
            this->connect(transfer.data(), SIGNAL(progressChanged(int)), this, SLOT(onTransferDataChanged()));
            this->connect(transfer.data(), SIGNAL(sizeChanged(qint64)), this, SLOT(onTransferDataChanged()));
            this->connect(transfer.data(), SIGNAL(statusChanged(Transfers::Status)), this, SLOT(onTransferDataChanged()));
            this->connect(transfer.data(), SIGNAL(priorityChanged(Transfers::Priority)), this, SLOT(onTransferDataChanged()));
        }
    }

    this->connect(TransferManager::instance(), SIGNAL(totalTransfersChanged(int)), this, SLOT(onTotalTransfersChanged()));

    emit countChanged(this->rowCount());
}

TransferListModel::~TransferListModel() {}

int TransferListModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return TransferManager::instance()->totalTransfers();
}

QVariant TransferListModel::data(const QModelIndex &index, int role) const {
    if (QSharedPointer<TransferItem> transfer = TransferManager::instance()->get(index.row())) {
        return transfer.data()->data(role);
    }

    return QVariant();
}

QVariant TransferListModel::data(int row, const QByteArray &role) const {
    return this->data(this->index(row), this->roleNames().key(role));
}

bool TransferListModel::setData(const QModelIndex &index, const QVariant &value, int role) {
    if (QSharedPointer<TransferItem> transfer = TransferManager::instance()->get(index.row())) {
        return transfer.data()->setData(role, value);
    }

    return false;
}

bool TransferListModel::setData(int row, const QVariant &value, const QByteArray &role) {
    return setData(this->index(row, 0), value, this->roleNames().key(role));
}

void TransferListModel::onTransferDataChanged() {
    if (TransferItem *transfer = qobject_cast<TransferItem*>(this->sender())) {
        int row = this->indexOf(transfer);
        emit dataChanged(this->index(row), this->index(row));
    }
}

void TransferListModel::onTotalTransfersChanged() {
    this->beginResetModel();
    this->endResetModel();
    emit countChanged(this->rowCount());
}

QSharedPointer<TransferItem> TransferListModel::get(int row) const {
    return TransferManager::instance()->get(row);
}

#ifdef QML_USER_INTERFACE
TransferItem* TransferListModel::getFromQML(int row) const {
    if (TransferItem *transfer = this->get(row).data()) {
        QDeclarativeEngine::setObjectOwnership(transfer, QDeclarativeEngine::CppOwnership);
        return transfer;
    }

    return 0;
}
#endif

int TransferListModel::indexOf(TransferItem *transfer) const {
    for (int i = 0; i < this->rowCount(); i++) {
        if (TransferManager::instance()->get(i).data() == transfer) {
            return i;
        }
    }

    return -1;
}
