#include "filterbox.h"
#include <QAction>

FilterBox::FilterBox(QWidget *parent) :
    QToolBar(parent),
    m_filterEdit(new QLineEdit(this)),
    m_cancelAction(this->addAction(QIcon::fromTheme("general_close"), QString(), this, SLOT(clear())))
{
    this->insertWidget(m_cancelAction, m_filterEdit);
    this->setFocusProxy(m_filterEdit);
    this->setAllowedAreas(Qt::BottomToolBarArea);

    this->connect(m_filterEdit, SIGNAL(textChanged(QString)), this, SIGNAL(filterTextChanged(QString)));
}

void FilterBox::clear() {
    m_filterEdit->clear();
    emit cleared();
}
