#ifndef DBUSINTERFACE_H_1324501701
#define DBUSINTERFACE_H_1324501701

#include <QtCore/QObject>
#include <QtCore/QByteArray>
#include <QtCore/QList>
#include <QtCore/QMap>
#include <QtCore/QStringList>
#include <QtCore/QVariant>
#include <QtDBus/QtDBus>

/*
 * Proxy class for interface com.maemo.cuteTube
 */
class DBusInterface: public QDBusAbstractInterface
{
    Q_OBJECT
public:
    static inline const char *staticInterfaceName()
    { return "com.maemo.cuteTube"; }

public:
    DBusInterface(const QString &service, const QString &path, const QDBusConnection &connection, QObject *parent = 0);

    ~DBusInterface();

public Q_SLOTS: // METHODS
    inline QDBusPendingReply<> display(const QStringList &url)
    {
        QList<QVariant> argumentList;
        argumentList << qVariantFromValue(url);
        return asyncCallWithArgumentList(QLatin1String("display"), argumentList);
    }

    inline QDBusPendingReply<> play(const QStringList &url)
    {
        QList<QVariant> argumentList;
        argumentList << qVariantFromValue(url);
        return asyncCallWithArgumentList(QLatin1String("play"), argumentList);
    }

    inline QDBusPendingReply<> display(const QString &url)
    {
        QList<QVariant> argumentList;
        argumentList << qVariantFromValue(url);
        return asyncCallWithArgumentList(QLatin1String("display"), argumentList);
    }

    inline QDBusPendingReply<> play(const QString &url)
    {
        QList<QVariant> argumentList;
        argumentList << qVariantFromValue(url);
        return asyncCallWithArgumentList(QLatin1String("play"), argumentList);
    }

Q_SIGNALS: // SIGNALS
};

namespace com {
  namespace marxian {
    typedef ::DBusInterface cuteTube;
  }
}
#endif
