#ifndef DAILYMOTIONVIDEOLISTWINDOW_H
#define DAILYMOTIONVIDEOLISTWINDOW_H

#include "stackedwindow.h"
#include "../base/groupitem.h"
#include "../base/videoitem.h"

class DailymotionVideoListModel;
class ListView;
class QAction;
class QLabel;
class QModelIndex;

class DailymotionVideoListWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit DailymotionVideoListWindow(QWidget *parent);
    void setVideoFeed(const QUrl &feed);
    void getGroupVideos(QSharedPointer<GroupItem> group);
    void search(const QString &query, Queries::QueryOrder order, const QString &language);

protected:
    void showEvent(QShowEvent *event);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void setMenuActions();
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void toggleGroupMembership();
    void deleteVideosFromUploads();
    void addVideosToFavourites();
    void deleteVideosFromFavourites();
    void addVideosToPlaylist();
    void addVideoDownloads();
    void addAudioDownloads();
    void queueVideos();
    void showContextMenu(const QPoint &pos);
    void deleteVideoFromUploads();
    void addVideoToFavourites();
    void deleteVideoFromFavourites();
    void showPlaylistDialog();
    void addVideoToPlaylist(const QString &id);
    void addVideoToNewPlaylist(const QVariantMap &playlist);
    void addVideoDownload();
    void addAudioDownload();
    void queueVideo();
    void onItemClicked(const QModelIndex &index);
    void showVideoInfo(QSharedPointer<VideoItem> video);
    void playVideo(const QModelIndex &index);

private:
    ListView *m_listView;
    DailymotionVideoListModel *m_model;
    QSharedPointer<GroupItem> m_group;
    QAction *m_groupAction;
    QAction *m_deleteFromUploadsAction;
    QAction *m_addToFavouritesAction;
    QAction *m_deleteFromFavouritesAction;
    QAction *m_addToPlaylistAction;
    QAction *m_addToQueueAction;
    QAction *m_videoDownloadAction;
    QAction *m_audioDownloadAction;
    QMenu *m_contextMenu;
    QAction *m_deleteFromUploadsContextAction;
    QAction *m_addToFavouritesContextAction;
    QAction *m_deleteFromFavouritesContextAction;
    QAction *m_addToPlaylistContextAction;
    QAction *m_addToQueueContextAction;
    QAction *m_videoDownloadContextAction;
    QAction *m_audioDownloadContextAction;
    QLabel *m_noResultsLabel;
};

#endif // DAILYMOTIONVIDEOLISTWINDOW_H
