#include "videoservicedialog.h"
#include "textlistdelegate.h"
#include "../base/selectionmodels.h"
#include "listview.h"
#include <QVBoxLayout>

VideoServiceDialog::VideoServiceDialog(QWidget *parent) :
    AbstractDialog(parent),
    m_model(new VideoServiceModel(this)),
    m_listView(new ListView(this))
{
    this->setWindowTitle(tr("Choose service"));
    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new TextListDelegate(Qt::DisplayRole, Qt::AlignCenter, m_listView));
    m_listView->setMinimumHeight(m_listView->sizeHintForRow(0) * 5);

    QVBoxLayout *vbox = new QVBoxLayout(this);
    vbox->addWidget(m_listView);

    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));

    this->onOrientationChanged();
}

void VideoServiceDialog::onItemClicked(const QModelIndex &index) {
    emit valueChanged(static_cast<Services::VideoService>(m_model->value(index.row()).toInt()));
    this->accept();
}
