#include "vimeocategorymodel.h"
#include "feedurls.h"

VimeoCategoryModel::VimeoCategoryModel(QObject *parent) :
    SelectionModel(parent)
{
    this->addItem(tr("Activism & Non Profits"), this->feedFromValue("activism"));
    this->addItem(tr("Animation & Motion Graphics"), this->feedFromValue("animation"));
    this->addItem(tr("Art"), this->feedFromValue("art"));
    this->addItem(tr("Comedy"), this->feedFromValue("comedy"));
    this->addItem(tr("Education & DIY"), this->feedFromValue("education"));
    this->addItem(tr("Everyday Life"), this->feedFromValue("everyday"));
    this->addItem(tr("Experimental"), this->feedFromValue("experimental"));
    this->addItem(tr("Films"), this->feedFromValue("films"));
    this->addItem(tr("HD"), this->feedFromValue("hd"));
    this->addItem(tr("Music"), this->feedFromValue("music"));
    this->addItem(tr("Nature"), this->feedFromValue("nature"));
    this->addItem(tr("Products & Equipment"), this->feedFromValue("productsandequipment"));
    this->addItem(tr("Science & Tech"), this->feedFromValue("technology"));
    this->addItem(tr("Sports"), this->feedFromValue("sports"));
    this->addItem(tr("Travel & Events"), this->feedFromValue("travel"));
    this->addItem(tr("Vimeo Projects"), this->feedFromValue("vimeoprojects"));
    this->addItem(tr("Web Series"), this->feedFromValue("webseries"));
    emit countChanged(this->rowCount());
}

QString VimeoCategoryModel::feedFromValue(const QString &value) {
    return QString("%1?method=vimeo.categories.getRelatedVideos&category=%2&full_response=true&per_page=30").arg(QString(VIMEO_BASE_URL)).arg(value);
}
