#ifndef UTILS_H
#define UTILS_H

#include "enums.h"
#include <QObject>
#include <QString>
#include <QDateTime>
#include <QVariantMap>

#ifndef QML_USER_INTERFACE
class QPainter;
class QRect;
class QImage;
#endif

class Utils : public QObject
{
    Q_OBJECT

public:
    explicit Utils(QObject *parent = 0);
    ~Utils();

    Q_INVOKABLE static QString durationFromSecs(int secs);
    Q_INVOKABLE static QString durationFromMSecs(int msecs);
    Q_INVOKABLE static QString fileSizeFromPath(const QString &filePath);
    Q_INVOKABLE static QString fileSizeFromBytes(double bytes);
    Q_INVOKABLE static QString dateFromSecs(qint64 secs, bool showTime = true);
    Q_INVOKABLE static QString dateFromMSecs(qint64 msecs, bool showTime = true);
    Q_INVOKABLE static QString localDateTimeFromString(const QString &dateTimeString, Qt::DateFormat = Qt::ISODate);
    Q_INVOKABLE static QString toRichText(QString s);
    Q_INVOKABLE static QVariantMap parseIdFromUrl(const QString &url);
    Q_INVOKABLE static QString base64Id(const QString &artist, const QString &title);
    Q_INVOKABLE static QString unescape(const QString &s);
    Q_INVOKABLE static void log(const QString &filePath, const QByteArray &message);
#ifndef QML_USER_INTERFACE
    static void drawBorderImage(QPainter *painter, const QRect &rect, const QImage &image, int top, int right, int left, int bottom);
#endif
};

#endif // UTILS_H
