#ifndef NETWORKPROXYDIALOG_H
#define NETWORKPROXYDIALOG_H

#include "abstractdialog.h"

class NetworkProxyTypeSelector;
class QCheckBox;
class QLineEdit;
class QDialogButtonBox;
class QGridLayout;
class QScrollArea;

class NetworkProxyDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit NetworkProxyDialog(QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();
    void loadSettings();

private slots:
    void saveSettings();
    void onProxyCheckboxToggled(bool checked);
    
private:
    QCheckBox *m_proxyCheckbox;
    QWidget *m_proxyWidget;
    NetworkProxyTypeSelector *m_proxyTypeSelector;
    QLineEdit *m_hostEdit;
    QLineEdit *m_portEdit;
    QLineEdit *m_userEdit;
    QLineEdit *m_passEdit;
    QScrollArea *m_scrollArea;
    QDialogButtonBox *m_buttonBox;
    QGridLayout *m_grid;
};

#endif // NETWORKPROXYDIALOG_H
