#include "youtubeuserlistwindow.h"
#include "youtubechannelwindow.h"
#include "youtubeuserlistdelegate.h"
#include "../base/youtubeuserlistmodel.h"
#include "listview.h"
#include <QLabel>
#include <QMaemo5Style>

YouTubeUserListWindow::YouTubeUserListWindow(QWidget *parent) :
    StackedWindow(parent),
    m_model(new YouTubeUserListModel(this)),
    m_listView(new ListView(this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:%1;font-size:40px;'><center><b>%2</b></center></p>").arg(QMaemo5Style::standardColor("SecondaryTextColor").name()).arg(tr("No channels found")), this))
{
    this->setCentralWidget(m_listView);

    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new YouTubeUserListDelegate(m_listView));
    m_noResultsLabel->hide();

    this->connect(m_model, SIGNAL(loadingChanged(bool)), this, SLOT(onLoadingChanged(bool)));
    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_listView, SIGNAL(atEnd()), m_model, SLOT(getMoreUsers()));

    this->onOrientationChanged();
}

void YouTubeUserListWindow::setFeed(const QUrl &feed) {
    m_model->getUsers(feed);
}

void YouTubeUserListWindow::search(const QString &query) {
    this->setWindowTitle(tr("Search") + QString(" ('%1')").arg(query));
    m_model->search(query);
}

void YouTubeUserListWindow::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void YouTubeUserListWindow::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void YouTubeUserListWindow::onLoadingChanged(bool loading) {
    this->toggleBusy(loading);
    m_noResultsLabel->setVisible((!loading) && (m_model->rowCount() == 0));
}

void YouTubeUserListWindow::onCountChanged(int count) {
    m_noResultsLabel->setVisible((count == 0) && (!m_model->loading()));
}

void YouTubeUserListWindow::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showUserChannel(index.data(AbstractUserListModel::IdRole).toString());
    }
}

void YouTubeUserListWindow::showUserChannel(const QString &userId) {
    YouTubeChannelWindow *window = new YouTubeChannelWindow(userId, this);
    window->show();
}
