#include "playbacklistmodel.h"
#include "transfermanager.h"

PlaybackListModel* queue = 0;

PlaybackListModel::PlaybackListModel(QObject *parent) :
    AbstractVideoListModel(parent)
{
    if (!queue) {
        queue = this;
    }
}

PlaybackListModel* PlaybackListModel::playbackQueue() {
    return queue;
}

void PlaybackListModel::insertVideo(int row, QSharedPointer<VideoItem> video) {
    AbstractVideoListModel::insertVideo(row, QSharedPointer<VideoItem>(video));
    emit alert(tr("Video added to playback queue"));
    emit countChanged(this->rowCount());
}

void PlaybackListModel::addVideo(QSharedPointer<VideoItem> video) {
    AbstractVideoListModel::appendVideo(QSharedPointer<VideoItem>(video));
    emit alert(tr("Video added to playback queue"));
    emit countChanged(this->rowCount());
}

void PlaybackListModel::addVideos(QList< QSharedPointer<VideoItem> > videos) {
    while (!videos.isEmpty()) {
        AbstractVideoListModel::appendVideo(QSharedPointer<VideoItem>(videos.takeFirst()));
    }

    emit alert(tr("Videos added to playback queue"));
    emit countChanged(this->rowCount());
}

#ifdef QML_USER_INTERFACE
void PlaybackListModel::insertVideoFromQML(int row, VideoItem *video) {
    AbstractVideoListModel::insertVideo(row, QSharedPointer<VideoItem>(new VideoItem(video)));
    emit alert(tr("Video added to playback queue"));
    emit countChanged(this->rowCount());
}

void PlaybackListModel::addVideoFromQML(VideoItem *video) {
    AbstractVideoListModel::appendVideo(QSharedPointer<VideoItem>(new VideoItem(video)));
    emit alert(tr("Video added to playback queue"));
    emit countChanged(this->rowCount());
}

void PlaybackListModel::addVideosFromQML(QList<VideoItem *> videos) {
    while (!videos.isEmpty()) {
        AbstractVideoListModel::appendVideo(QSharedPointer<VideoItem>(new VideoItem(videos.takeFirst())));
    }

    emit alert(tr("Videos added to playback queue"));
    emit countChanged(this->rowCount());
}
#endif

void PlaybackListModel::removeVideo(int row) {
    this->removeRow(row);
    emit countChanged(this->rowCount());
}

void PlaybackListModel::removeSelectedVideos() {
    qSort(m_selectedRows.begin(), m_selectedRows.end(), qGreater<int>());

    for (int i = 0; i < m_selectedRows.size(); i++) {
        this->removeVideo(m_selectedRows.at(i));
    }

    this->selectNone();
    emit countChanged(this->rowCount());
}

void PlaybackListModel::downloadSelectedVideos(bool saveAsAudio) {
    TransferManager::instance()->addDownloadTransfers(this->selectedItems(), saveAsAudio);
    this->selectNone();
}
