# -*- coding: utf-8 -*-

"""
Module providing access to the YouTube API and downloading of videos.
"""
from __future__ import with_statement
from PyQt4.QtCore import *
from PyQt4.QtGui import *
import urllib2
import urllib
from cgi import parse_qs
import re
import time
import os
import shutil
import gdata.youtube.service
import gdata.service
from cutetubeconfig import *
from cutetubelog import CutetubeLog

class YouTubeDataService(object):
    """
    Class providing access to the YouTube API.
    """
    #Static variables
    currentUser = ""
    ytService = gdata.youtube.service.YouTubeService()
    ytService.email = ""
    ytService.password = ""
    ytService.source = "cuteTube"
    ytService.developer_key = "AI39si6x9O1gQ1Z_BJqo9j2n_SdVsHu1pk2uqvoI3tVq8d6alyc1og785IPCkbVY3Q5MFuyt-IFYerMYun0MnLdQX5mo2BueSw"
    stdHeaders = {
    'User-Agent': 'Mozilla/5.0 (X11; U; Linux x86_64; en-US; rv:1.9.2.8) Gecko/20100723 Firefox/3.6.8',
    'Accept-Charset': 'ISO-8859-1,utf-8;q=0.7,*;q=0.7',
    'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
    'Accept-Language': 'en-us,en;q=0.5',
    }
    
    def __init__(self,  parent):
        object.__init__(self,  parent)
    
    @staticmethod
    def youtubeLogin(username):
        """
        Logs in to the user's chosen YouTube account.
        """       
        YouTubeDataService.ytService.email = unicode(YouTubeAPISettings.userDict[username][0], "utf-8")
        YouTubeDataService.ytService.password = unicode(YouTubeAPISettings.userDict[username][1], "utf-8")
        try:
            CutetubeLog.logInfo("Attempting to sign in to YouTube account: %s" % username)
            YouTubeDataService.ytService.ProgrammaticLogin()
            YouTubeDataService.currentUser = username
            CutetubeLog.logInfo("Signed in to YouTube account: %s" % username)
            result = True
        except:
            try:
                # Some users have reported authentication issues. Using the username in place of the email address may work.
                YouTubeDataService.ytService.email = unicode(username, "utf-8")
                YouTubeDataService.ytService.password = unicode(YouTubeAPISettings.userDict[username][1], "utf-8")
                YouTubeDataService.ytService.ProgrammaticLogin()
                YouTubeDataService.currentUser = username
                CutetubeLog.logInfo("Signed in to YouTube account: %s" % username)
                result = True
            except Exception, e:
                CutetubeLog.logException("Unable to sign in to YouTube account:")
                result = False
        return result
        
    @staticmethod
    def addComment(comment, videoId):
        """
        Adds a comment to the video argument's comment feed.
        """
        videoEntry = YouTubeDataService.getVideoEntry(videoId)
        YouTubeDataService.ytService.AddComment(unicode(comment), videoEntry) 

    @staticmethod
    def addLikeOrDislike(likeOrDislike, videoId):
        """
        Adds a rating to the video argument.
        """
        videoEntry = YouTubeDataService.getVideoEntry(videoId, apiVersion = 2)
        try:
            YouTubeDataService.ytService.AddLikeOrDislike(likeOrDislike, videoEntry)
            result = True
        except gdata.service.Error, e:
            result = e.args[0].get("body")
            CutetubeLog.logException(e)
        return result
    
    @staticmethod
    def addSubscription(username):
        """
        Adds a subscription to the username argument.
        """
        try:
            YouTubeDataService.ytService.AddSubscriptionToChannel(username)
            result = True
        except gdata.service.Error, e:
            result = e.args[0].get("body")
            CutetubeLog.logException(e)
        return result

    @staticmethod
    def removeSubscription(subscriptionUri):
        """
        Removes the subscription to the specified channel.
        """
        try:
            YouTubeDataService.ytService.DeleteSubscription(subscriptionUri)
            result = True
        except gdata.service.Error, e:
            result = e.args[0].get("body")
            CutetubeLog.logException(e)
        return result

    @staticmethod
    def addVideoToFavourites(videoId):
        video = YouTubeDataService.getVideoEntry(videoId)
        try:
            YouTubeDataService.ytService.AddVideoEntryToFavorites(video)
            result = True
        except gdata.service.Error, e:
            result = e.args[0].get("body")
            CutetubeLog.logException(e)
        return result

    @staticmethod
    def removeVideoFromFavourites(videoId):
        try:
            YouTubeDataService.ytService.DeleteVideoEntryFromFavorites(videoId)
            result = True
        except gdata.service.Error, e:
            result = e.args[0].get("body")
            CutetubeLog.logException(e)
        return result

    @staticmethod
    def newPlaylist(playlistTitle, playlistDescription, private):
        """
        Creates a new playlist using the title and description arguments.
        """
        try:
            YouTubeDataService.ytService.AddPlaylist(playlistTitle, playlistDescription, private)
            result = True
        except gdata.service.Error, e:
            result = e.args[0].get("body")
            CutetubeLog.logException(e)
        return result


    @staticmethod
    def addVideoToPlaylist(playlistId, videoId):
        """
        Add the current video to the chosen playlist.
        """
        playlistUri = "http://gdata.youtube.com/feeds/api/playlists/%s" % playlistId
        YouTubeDataService.ytService.AddPlaylistVideoEntryToPlaylist(playlistUri, videoId)

    @staticmethod
    def removeVideoFromPlaylist(playlistId, videoId):
        """
        Removes the chosen video from the playlist.
        """
        playlistUri = "http://gdata.youtube.com/feeds/api/playlists/%s" % playlistId
        try:
            YouTubeDataService.ytService.DeletePlaylistVideoEntry(playlistUri, videoId)
            result = True
        except gdata.service.Error, e:
            result = e.args[0].get("body")
            CutetubeLog.logException(e)
        return result

    @staticmethod
    def updatePlaylistVideo(playlistId, playlistVideoId, newVideoTitle, newVideoDescription, newPosition):
        YouTubeDataService.ytService.UpdatePlaylistVideoEntryMetaData(playlistId, playlistVideoId, newVideoTitle, newVideoDescription, newPosition)

    @staticmethod
    def updatePlaylist(playlistId, newPlaylistTitle, newPlaylistDescription, private):
        YouTubeDataService.ytService.UpdatePlaylist(playlistId, newPlaylistTitle, newPlaylistDescription, private)

    @staticmethod
    def deletePlaylist(playlistId):
        playlistUri = "http://gdata.youtube.com/feeds/api/users/default/playlists/%s" % playlistId
        try:
            YouTubeDataService.ytService.DeletePlaylist(playlistUri)
            result = True
        except gdata.service.Error, e:
            result = e.args[0].get("body")
            CutetubeLog.logException(e)
        return result

    @staticmethod
    def getVideoEntry(videoId, apiVersion = 1):
        try:
            videoEntry = YouTubeDataService.ytService.GetYouTubeVideoEntry(video_id = videoId, api_version = apiVersion)
        except:
            videoEntry = YouTubeDataService.ytService.GetYouTubeVideoEntry(videoId, api_version = apiVersion)
        return videoEntry
        
    @staticmethod
    def getVideoRestrictions(video):
        """
        Checks for any restrictions that may apply to the video.
        """
        restriction = None
        try:
            if video.control.FindExtensions()[0].text != "Syndication of this video was restricted by its owner.":
                restriction = video.control.FindExtensions()[0].text
                CutetubeLog.logException("Error retrieving %s: %s" % (video.media.title.text, restriction))
        except:
            restriction = None
        return restriction

    @staticmethod
    def getVideoThumbnail(thumbUrl):
        """
        Retrieves and returns the thumbnail for the video.
        """
        try:
            opener = urllib2.build_opener()
            thumbPage = opener.open(thumbUrl)
            image = QImage()
            if image.loadFromData(thumbPage.read()):
                thumbnail = QPixmap.fromImage(image)
        except:
            thumbnail = None
        return thumbnail

    @staticmethod
    def updateVideo(videoId, newVideoTitle, newVideoDescription):
        video = YouTubeDataService.getVideoEntry(videoId)
        video.media.title.text = newVideoTitle
        video.media.description.text = newVideoDescription
        video.link.append(atom.Link(rel='edit', href='http://gdata.youtube.com/feeds/api/users/%s/uploads/%s' % (YouTubeDataService.currentUser, videoId.split("/")[-1])))
        YouTubeDataService.ytService.UpdateVideoEntry(video)

    @staticmethod
    def deleteVideo(videoId):
        """
        Deletes the video from the user's uploads.
        """
        videoEntry = YouTubeDataService.ytService.GetYouTubeVideoEntry(videoId)
        YouTubeDataService.ytService.DeleteVideoEntry(videoEntry)

    @staticmethod
    def getVideoUrl(video,  videoFormat = 18):
        """
        Returns the YouTube video url for download or playback.
        In the case of a download, if the user-chosen format is not 
        available, the next available format will be used.
        Much of the code for this method is borrowed from youtube.py 
        of MediaBox.
        """
        try:
            CutetubeLog.logInfo("Retreiving video URL for \'%s\' (id = %s)" % (video.media.title.text, video.media.player.url.split("=") [1].split("&")[0]))
            videoUrl = ""       
            playerUrl = video.media.player.url.split("&")[0]
            html = urllib.urlopen(playerUrl).read()
            html = "".join(html.split())
            formats = {}
            pos = html.find("\",\"fmt_url_map\":\"")
            if (pos != -1):
                pos2 = html.find("\"", pos + 17)
                fmt_map = urllib.unquote(html[pos + 17:pos2]) + ","
                parts = fmt_map.split("|")
                key = parts[0]
                for p in parts[1:]:
                    idx = p.rfind(",")
                    value = p[:idx].replace("\\/", "/")
                    formats[int(key)] = value
                    key = p[idx + 1:]
                
            formatList = [22, 35, 34, 18, 17]
            for format in formatList[formatList.index(videoFormat):]:
                if videoFormat in formats:
                    videoUrl = formats.get(videoFormat)
                    break
                break
            return videoUrl
        except Exception, e:
            CutetubeLog.logException("Unable to retrieve video URL for \'%s\' (id = %s)" % (video.media.title.text, video.media.player.url.split("=") [1].split("&")[0]))

class YouTubeVideoFeed(QThread):
    """
    Pulls the video feed from the YouTube server.
    """

    def __init__(self, parent, videoFeed):
        QThread.__init__(self, parent)
        self.videoFeed = videoFeed
        self.videoList = []
        self.results = 0
        self.thumbcount = 0
        self.moreResults = True
        
    def resetResultCount(self):
        """
        Resets the result and thumbnail count to zero.
        """
        self.videoList = []
        self.results = 0
        self.thumbcount = 0
    
    def getVideoFeed(self, retriesRemaining = 3):
        """
        Retrieves and returns the video feed.
        """
        try:
            try:
                self.ytVideoFeed = YouTubeDataService.ytService.GetYouTubeVideoFeed(("%s?start-index=%d&v=2" % (self.videoFeed, self.results + 1)).encode("utf-8"))
            except:
                self.ytVideoFeed = YouTubeDataService.ytService.GetYouTubeVideoFeed(("%s&start-index=%d&v=2" % (self.videoFeed, self.results + 1)).encode("utf-8"))
            for link in self.ytVideoFeed.link:
                self.moreResults = (link.rel == "next")
        except Exception, e:
            if retriesRemaining > 0:
                retriesRemaining -= 1                
                CutetubeLog.logException("Unable to retrieve video feed. Trying again")
                self.getVideoFeed(retriesRemaining)
            else:
                CutetubeLog.logException("Unable to retrieve video feed. Aborting")
            
    def getVideoData(self):
        """
        Returns the xml for each video.
        """
        for video in self.ytVideoFeed.entry:
            try:
                if video.media.player != None:
                    self.videoList.append(video)
                    self.emit(SIGNAL("dataLoaded(PyQt_PyObject)"), video)
                    self.results += 1
            except Exception, e:
                CutetubeLog.logException("Unable to retrieve video entry: \'%s\': " % video.media.title.text)
                
    def getThumbnails(self):
        """
        Retrieves and returns the thumbnail for each video.
        """
        for video in self.videoList[self.thumbcount:]:
            try:
                thumbnail = YouTubeDataService.getVideoThumbnail(video.media.thumbnail[0].url)
                self.emit(SIGNAL("thumbnailLoaded(PyQt_PyObject)"), (self.thumbcount, thumbnail))
                self.thumbcount += 1
            except Exception, e:
                CutetubeLog.logException("Unable to retrieve thumbnail for: \'%s\': " % video.media.title.text)

    def run(self):
        self.emit(SIGNAL("feedCompleted(bool)"), True)
        self.getVideoFeed() 
        self.getVideoData()
        self.emit(SIGNAL("feedCompleted(bool)"), False)
        self.getThumbnails()

class YouTubeQueueFeed(QThread):
    """
    Pulls the video feed from the YouTube server.
    """
    #Static variables
    playlist = []

    def __init__(self, parent):
        QThread.__init__(self, parent)
    
    def getQueueFeed(self):
        """
        Retrieves and returns the video feed.
        """
        for video in YouTubeQueueFeed.playlist:
            try:
                self.emit(SIGNAL("dataLoaded(PyQt_PyObject)"), video)
            except:
                pass
                
    def getThumbnails(self):
        """
        Retrieves and returns the thumbnail for each video.
        """
        row = 0
        for video in YouTubeQueueFeed.playlist:
            try:
                thumbnail = YouTubeDataService.getVideoThumbnail(video.media.thumbnail[0].url)
                self.emit(SIGNAL("thumbnailLoaded(PyQt_PyObject)"), (row, thumbnail))
                row += 1
            except Exception, e:
                CutetubeLog.logException("Unable to retrieve thumbnail for: \'%s\': " % video.media.title.text)

    def run(self):
        self.emit(SIGNAL("feedCompleted(bool)"), True)
        self.getQueueFeed()
        self.emit(SIGNAL("feedCompleted(bool)"), False)
        self.getThumbnails()

class YouTubeDownloadQueueFeed(QThread):
    """
    Pulls the video feed from the YouTube server.
    """
    def __init__(self, parent):
        QThread.__init__(self, parent)
    
    def getQueueFeed(self):
        """
        Retrieves and returns the video feed.
        """
        for task in YouTubeVideoDownloader.taskQueue:
            try:
                video = task.video
                self.emit(SIGNAL("dataLoaded(PyQt_PyObject)"), video)
            except:
                pass
                
    def getThumbnails(self):
        """
        Retrieves and returns the thumbnail for each video.
        """
        row = 0
        for task in YouTubeVideoDownloader.taskQueue:
            try:
                video = task.video
                thumbnail = YouTubeDataService.getVideoThumbnail(video.media.thumbnail[0].url)
                self.emit(SIGNAL("thumbnailLoaded(PyQt_PyObject)"), (row, thumbnail))
                row += 1
            except Exception, e:
                CutetubeLog.logException("Unable to retrieve thumbnail for: \'%s\': " % video.media.title.text)

    def run(self):
        self.emit(SIGNAL("feedCompleted(bool)"), True)
        self.getQueueFeed()
        self.emit(SIGNAL("feedCompleted(bool)"), False)
        self.getThumbnails()

class YouTubePlaylistFeed(QThread):
    """
    Pulls the user's playlist feed.
    """

    def __init__(self, parent):
        QThread.__init__(self, parent)
        self.retriesRemaining = 3

    
    def getPlaylistFeed(self):
        """
        Retrieves and returns the user's playlist feed.
        """
        playlistsUri = "http://gdata.youtube.com/feeds/api/users/default/playlists?max-results=50&v=2"
        try:
            self.playlistFeed = YouTubeDataService.ytService.GetYouTubePlaylistFeed(uri = playlistsUri)
            self.emit(SIGNAL("dataLoaded(PyQt_PyObject)"), self.playlistFeed.entry)
        except Exception, e:
            if self.retriesRemaining > 0:
                CutetubeLog.logException("Unable to retrieve playlist feed. Trying again")
                self.retriesRemaining -= 1
                self.getPlaylistFeed()
            else:
                CutetubeLog.logException("Unable to retrieve playlist feed. Aborting")
    
    def run(self):
        self.getPlaylistFeed()

class YouTubeSubscriptionsFeed(QThread):
    """
    Provides access to the user's subscriptions.
    """
    def __init__(self, parent):
        """
        Constructor
        """
        QThread.__init__(self, parent)
        self.retriesRemaining = 3

    def getSubscriptionsFeed(self):
        """
        Retrieves the user's subscriptions feed.
        """
        subscriptionsUri = "http://gdata.youtube.com/feeds/api/users/default/subscriptions?max-results=50&v=2"
        try:
            self.subscriptionsFeed = YouTubeDataService.ytService.GetYouTubeSubscriptionFeed(uri = subscriptionsUri)
            self.emit(SIGNAL("dataLoaded(PyQt_PyObject)"), self.subscriptionsFeed.entry)
        except Exception, e:
            if self.retriesRemaining > 0:
                CutetubeLog.logException("Unable to retrieve subscriptions feed. Trying again")
                self.retriesRemaining -= 1
                self.getSubscriptionsFeed()
            else:
                CutetubeLog.logException("Unable to retrieve subscriptions feed. Aborting")

    def run(self):
        self.getSubscriptionsFeed()

class YouTubeCommentsFeed(QThread):
    """
    Retrieves and returns the comments feed 
    for the video.
    """
    def __init__(self, parent, videoId):
        """
        Constructor
        """
        QThread.__init__(self, parent)
        self.videoId = videoId
        self.retriesRemaining = 3

    def getVideoComments(self):
        """
        Retrieves and returns the comments feed 
        for the video.
        """
        try:
            comments = YouTubeDataService.ytService.GetYouTubeVideoCommentFeed(video_id = self.videoId)
            self.emit(SIGNAL("dataLoaded(PyQt_PyObject)"), comments.entry)
        except Exception, e:
            if self.retriesRemaining > 0:
                CutetubeLog.logException("Unable to retrieve comments feed. Trying again")
                self.retriesRemaining -= 1
                self.getVideoComments()
            else:
                CutetubeLog.logException("Unable to retrieve comments feed. Aborting")

    def run(self):
        self.getVideoComments()

class YouTubeVideoDownloader(object):
    """
    Manages download tasks in the download queue.
    """
    # Static variables
    taskQueue = []
    currentTask = None
    currentStatus = "inactive"

    def __init__(self, parent = None):
        """
        Constructor
        """
        object.__init__(self, parent = None)
        
    @staticmethod
    def addTask(video):
        """
        Add the video to the download queue. 
        """
        task = DownloadTask(video)
        YouTubeVideoDownloader.taskQueue.append(task)
        if YouTubeVideoDownloader.currentStatus == "inactive" and VideoDownloadSettings.defaultTaskStatus == "queued":
            YouTubeVideoDownloader.run()
            
    @staticmethod
    def pauseTask(task):
        """
        Sets the status of the task to "paused".
        """
        YouTubeVideoDownloader.taskQueue[task].setStatus("paused")
        
    @staticmethod
    def cancelTask(task):
        """
        Sets the status of the task to "cancelled"
        """
        YouTubeVideoDownloader.taskQueue[task].setStatus("cancelled")
            
    @staticmethod
    def resumeTask(task):
        """
        Sets the status of the task to "queued" and resumes the download 
        if currentStatus is "inactive".
        """
        YouTubeVideoDownloader.taskQueue[task].setStatus("queued")
        if YouTubeVideoDownloader.currentStatus == "inactive":
            YouTubeVideoDownloader.run()
            
    @staticmethod
    def clearTasks():
        """
        Clears the taskQueue.
        """
        YouTubeVideoDownloader.taskQueue = []
        
    @staticmethod
    def saveTasks():
        """
        Saves any incomplete download tasks.
        """
        taskList = []
        for task in YouTubeVideoDownloader.taskQueue:
            if task.getStatus() in ("paused", "queued", "downloading"):
                savedTask = task.getId()
                taskList.append(savedTask)
        return taskList
        
    @staticmethod
    def restoreTasks(taskList):
        """
        Restores any saved tasks.
        """
        for task in taskList:
            videoId = unicode(task, "utf-8")
            video = YouTubeDataService.getVideoEntry(videoId)
            YouTubeVideoDownloader.addTask(video)
    
    @staticmethod
    def run():
        for task in YouTubeVideoDownloader.taskQueue:
            if task.getStatus() == "queued":
                YouTubeVideoDownloader.currentTask = task
                YouTubeVideoDownloader.currentTask.start(QThread.LowPriority)
                YouTubeVideoDownloader.currentStatus = "active"
                break
        else:
            YouTubeVideoDownloader.currentStatus = "inactive"

class DownloadTask(QThread):
    """
    Thread that carries out individual video downloads. Much of the 
    code is taken from download.py of gPodder.
    """
        
    def getTitle(self):
        return self.video.media.title.text
        
    def getId(self):
        return self.video.media.player.url.split("=") [1].split("&")[0]
        
    def getVideo(self):
        return self.video

    def getStatus(self):
        return self.status

    def setStatus(self, status):
        if status != self.getStatus:
            self.statusChanged = True
            self.status = status
        
    def removedFromList(self):
        if self.status != "completed":
            os.remove(self.tempname)

    def __init__(self, video):
        QThread.__init__(self,  parent = None)
        self.status = VideoDownloadSettings.defaultTaskStatus
        self.statusChanged = True
        self.video = video
        self.connect(self,  SIGNAL("finished()"),  YouTubeVideoDownloader.run)

        # Create the target filename
        if VideoDownloadSettings.downloadFormat in (34, 35, 22):
            formatExt = "HQ"
            self.filename = "%s/%s-%s.mp4" % (VideoDownloadSettings.downloadFolder, unicode(re.sub('[:/|\\\\]', "-", self.video.media.title.text), "utf-8"), formatExt)
        else:
            self.filename = "%s/%s.mp4" % (VideoDownloadSettings.downloadFolder, unicode(re.sub('[:/|\\\\]', "-", self.video.media.title.text), "utf-8"))
        self.tempname = self.filename + '.partial'

        self.totalSize = 0
        self.speed = 0.0
        self.progress = 0.0
        self.errorMessage = None

        # Variables for speed calculation
        self.startTime = 0
        self.startBlocks = 0

        # If the tempname already exists, set progress accordingly
        if os.path.exists(self.tempname):
            try:
                already_downloaded = os.path.getsize(self.tempname)
                if self.totalSize > 0:
                    self.progress = max(0.0, min(1.0, float(alreadyDownloaded)/self.totalSize))
            except OSError, os_error:
                print 'Error while getting size for existing file: %s' % os_error

    def statusUpdated(self, count, blockSize, totalSize):
        # We see a different "total size" while downloading,
        # so correct the total size variable in the thread
        if totalSize != self.totalSize and totalSize > 0:
            self.totalSize = float(totalSize)

        if self.totalSize > 0:
            self.progress = max(0.0, min(1.0, float(count*blockSize)/self.totalSize))

        self.calculateSpeed(count, blockSize)

        if self.status == "cancelled":
            raise DownloadCancelledException()

        if self.status == "paused":
            raise DownloadCancelledException()
            
        self.emit(SIGNAL("downloadUpdated()"))

    def calculateSpeed(self, count, blockSize):
        if count % 5 == 0:
            now = time.time()
            if self.startTime > 0:
                passed = now - self.startTime
                if passed > 0:
                    speed = ((count-self.startBlocks)*blockSize)/passed
                else:
                    speed = 0
            else:
                self.startTime = now
                self.startBlocks = count
                passed = now - self.startTime
                speed = count*blockSize

            self.speed = float(speed/1000)

    def run(self):
        # Speed calculation (re-)starts here
        self.startTime = 0
        self.startBlocks = 0

        # If the download has already been cancelled, skip it
        if self.status == "cancelled":
            os.remove(self.tempname)
            self.progress = 0.0
            self.speed = 0.0

        # We are downloading this file right now
        self.status = "downloading"

        try:
            # Resolve URL and start downloading the episode
            url = YouTubeDataService.getVideoUrl(self.video,  VideoDownloadSettings.downloadFormat)
            downloader =  DownloadURLOpener()
            headers, realUrl = downloader.retrieveResume(url, \
                    self.tempname, reporthook=self.statusUpdated)

            shutil.move(self.tempname, self.filename)
            self.status = "completed"
            self.speed = 0.0

        except DownloadCancelledException:
            print'Download has been cancelled/paused'
            if self.status == "cancelled":
                os.remove(self.tempname)
                self.progress = 0.0
                self.speed = 0.0
                self.emit(SIGNAL("statusChanged()"))
        except urllib.ContentTooShortError, ctse:
            self.status = "failed"
            CutetubeLog.logException("Missing content from server")
            self.emit(SIGNAL("statusChanged()"))
            
        except IOError, ioe:
            CutetubeLog.logException("Error %s while downloading %s" % (ioe.strerror, self.video.media.title.text))
            self.status = "failed"
            self.emit(SIGNAL("statusChanged()"))
        except Exception, e:
            self.status = "failed"
            CutetubeLog.logException("Error: %s" % e.message)
            self.emit(SIGNAL("statusChanged()"))
        
        
class ContentRange(object):
    # Based on:
    # http://svn.pythonpaste.org/Paste/WebOb/trunk/webob/byterange.py
    #
    # Copyright (c) 2007 Ian Bicking and Contributors
    #
    # Permission is hereby granted, free of charge, to any person obtaining
    # a copy of this software and associated documentation files (the
    # "Software"), to deal in the Software without restriction, including
    # without limitation the rights to use, copy, modify, merge, publish,
    # distribute, sublicense, and/or sell copies of the Software, and to
    # permit persons to whom the Software is furnished to do so, subject to
    # the following conditions:
    #
    # The above copyright notice and this permission notice shall be
    # included in all copies or substantial portions of the Software.
    #
    # THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    # EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    # MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    # NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    # LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
    # OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
    # WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
    """
    Represents the Content-Range header

    This header is ``start-stop/length``, where stop and length can be
    ``*`` (represented as None in the attributes).
    """

    def __init__(self, start, stop, length):
        assert start >= 0, "Bad start: %r" % start
        assert stop is None or (stop >= 0 and stop >= start), (
            "Bad stop: %r" % stop)
        self.start = start
        self.stop = stop
        self.length = length

    def __repr__(self):
        return '<%s %s>' % (
            self.__class__.__name__,
            self)

    def __str__(self):
        if self.stop is None:
            stop = '*'
        else:
            stop = self.stop + 1
        if self.length is None:
            length = '*'
        else:
            length = self.length
        return 'bytes %s-%s/%s' % (self.start, stop, length)

    def __iter__(self):
        """
        Mostly so you can unpack this, like:

            start, stop, length = res.content_range
        """
        return iter([self.start, self.stop, self.length])

    @classmethod
    def parse(cls, value):
        """
        Parse the header.  May return None if it cannot parse.
        """
        if value is None:
            return None
        value = value.strip()
        if not value.startswith('bytes '):
            # Unparseable
            return None
        value = value[len('bytes '):].strip()
        if '/' not in value:
            # Invalid, no length given
            return None
        range, length = value.split('/', 1)
        if '-' not in range:
            # Invalid, no range
            return None
        start, end = range.split('-', 1)
        try:
            start = int(start)
            if end == '*':
                end = None
            else:
                end = int(end)
            if length == '*':
                length = None
            else:
                length = int(length)
        except ValueError:
            # Parse problem
            return None
        if end is None:
            return cls(start, None, length)
        else:
            return cls(start, end-1, length)
        
class DownloadURLOpener(urllib.FancyURLopener):
    """
    This code is from download.py of gPodder.
    """
    def __init__(self):
        urllib.FancyURLopener.__init__(self, None)

    def retrieveResume(self, url, filename, reporthook=None, data=None):
        """Download files from an URL; return (headers, real_url)

        Resumes a download if the local filename exists and
        the server supports download resuming.
        """

        currentSize = 0
        tfp = None
        if os.path.exists(filename):
            try:
                currentSize = os.path.getsize(filename)
                tfp = open(filename, 'ab')
                #If the file exists, then only download the remainder
                if currentSize > 0:
                    self.addheader('Range', 'bytes=%s-' % (currentSize))
            except:
                print 'Cannot open file for resuming: %s' % filename
                tfp = None
                currentSize = 0

        if tfp is None:
            tfp = open(filename, 'wb')

        url = urllib.unwrap(urllib.toBytes(url))
        fp = self.open(url, data)
        headers = fp.info()

        if currentSize > 0:
            # We told the server to resume - see if she agrees
            # See RFC2616 (206 Partial Content + Section 14.16)
            # XXX check status code here, too...
            range = ContentRange.parse(headers.get('content-range', ''))
            if range is None or range.start != currentSize:
                # Ok, that did not work. Reset the download
                # TODO: seek and truncate if content-range differs from request
                tfp.close()
                tfp = open(filename, 'wb')
                currentSize = 0
                print 'Cannot resume. Missing or wrong Content-Range header (RFC2616)'

        result = headers, fp.geturl()
        bs = 1024*8
        size = -1
        read = currentSize
        blocknum = int(currentSize/bs)
        if reporthook:
            if "content-length" in headers:
                size = int(headers["Content-Length"]) + currentSize
            reporthook(blocknum, bs, size)
        while read < size or size == -1:
            if size == -1:
                block = fp.read(bs)
            else:
                block = fp.read(min(size-read, bs))
            if block == "":
                break
            read += len(block)
            tfp.write(block)
            blocknum += 1
            if reporthook:
                reporthook(blocknum, bs, size)
        fp.close()
        tfp.close()
        del fp
        del tfp

        # raise exception if actual size does not match content-length header
        if size >= 0 and read < size:
            raise urllib.ContentTooShortError("retrieval incomplete: got only %i out "
                                       "of %i bytes" % (read, size), result)

        return result
        
class DownloadCancelledException(Exception): pass
