# -*- coding: utf-8 -*-

"""
Module implementing the logging of errors.
"""

import logging
import logging.handlers

class CutetubeLog():
    """
    Provides the application's logging functions.
    """
    LOGFILE = "/home/user/.config/Stuart Howarth/cuteTube.log"
    logger = logging.getLogger('logger')
    logger.setLevel(logging.DEBUG)
    handler = logging.handlers.RotatingFileHandler(LOGFILE, maxBytes=30000, backupCount=1)
    formatter = logging.Formatter("%(asctime)s - %(levelname)s - %(message)s",  datefmt = "%a, %d %b %Y %H:%M:%S")
    handler.setFormatter(formatter)
    logger.addHandler(handler)
    
    @staticmethod
    def logInfo(info):
        """
        Logs the info to the text file.
        """
        CutetubeLog.logger.info(info)
        
    @staticmethod
    def logException(exception):
        """
        Logs the error to the text file.
        """
        CutetubeLog.logger.exception(exception)
