# -*- coding: utf-8 -*-

"""
This module facilitates the sharing of YouTube videos via social media 
such as Twitter.
"""

import os
import sys

# parse_qsl moved to urlparse module in v2.6
try:
  from urlparse import parse_qsl
except:
  from cgi import parse_qsl

import oauth2 as oauth
import twitter
from cutetubeconfig import VideoSharingSettings

class Twitter():
    """
    Provides access to Twitter. This class is never instantiated.
    """
    #Static constants
    REQUEST_TOKEN_URL = 'https://api.twitter.com/oauth/request_token'
    ACCESS_TOKEN_URL  = 'https://api.twitter.com/oauth/access_token'
    AUTHORIZATION_URL = 'https://api.twitter.com/oauth/authorize'
    SIGNIN_URL        = 'https://api.twitter.com/oauth/authenticate'

    #Static variables
    consumer_key    = "YmfKe14OCdVxn9FCL1S77A"
    consumer_secret = "evSW7txyhlvvPXkezKvJgaZ2lC97iXZc4ZLXLZxfsfc"

    signature_method_hmac_sha1 = oauth.SignatureMethod_HMAC_SHA1()
    oauth_consumer             = oauth.Consumer(key=consumer_key, secret=consumer_secret)
    oauth_client               = oauth.Client(oauth_consumer)
    
    request_token = {}

    @staticmethod
    def getAuthorisationUrl():
        """
        Returns the URL for the Twitter authorisation.
        """
    
        print 'Requesting temp token from Twitter'
    
        resp, content = Twitter.oauth_client.request(Twitter.REQUEST_TOKEN_URL, 'GET')
    
        if resp['status'] != '200':
            print 'Invalid respond from Twitter requesting temp token: %s' % resp['status']
        else:
            Twitter.request_token = dict(parse_qsl(content))
        return "%s?oauth_token=%s" % (Twitter.AUTHORIZATION_URL, Twitter.request_token['oauth_token'])
    
    @staticmethod
    def getAccessToken(pincode):
        """
        Uses the pincode argument to retreive the access token.
        """
    
        token = oauth.Token(Twitter.request_token['oauth_token'], Twitter.request_token['oauth_token_secret'])
        token.set_verifier(pincode)
        oauth_client  = oauth.Client(Twitter.oauth_consumer, token)
        resp, content = oauth_client.request(Twitter.ACCESS_TOKEN_URL, method='POST', body='oauth_verifier=%s' % pincode)
        access_token  = dict(parse_qsl(content))
    
        if resp['status'] != '200':
            print 'The request for a Token did not succeed: %s' % resp['status']
        return (access_token['oauth_token'], access_token['oauth_token_secret'])
        
    @staticmethod
    def postMessage(message):
        """
        Posts the message to Twitter.
        """
        api = twitter.Api(consumer_key = Twitter.consumer_key, consumer_secret = Twitter.consumer_secret, access_token_key = unicode(VideoSharingSettings.twitterAccessTokenKey, "utf-8"), access_token_secret = unicode(VideoSharingSettings.twitterAccessTokenSecret, "utf-8"))
        api.PostUpdate(message)
        
class Facebook():
    """
    Provides access to Facebook status updating. This class is never instantiated.
    """
    #Static constants
    AUTHORISATION_URL = "https://graph.facebook.com/oauth/authorize"
    REDIRECT_URL = "http://www.facebook.com/connect/login_success.html"
    
    #Static variables
    clientId = "175388745824052"
    clientSecret = "b98565da82716e57255e27fb4bbba0eb"

    @staticmethod
    def getAccessToken():
        """
        Retrieves the access token following user authorisation.
        """
        pass
        
