#!/usr/bin/env python

from optparse import OptionParser, OptionGroup
import sys

from network import Client, Server
from square import SquareGame
import timer
import cute

# WARNING: You might lose a leg if you move this!!!!
# Seriously, moving this import up might kill kittens!!!
from threading import Thread

usage = "Usage: %prog [options] Playername ..."
parser = OptionParser(usage=usage)

group = OptionGroup(parser, "Network", "Use these options to start a network game. The Server sets the game properties.")
group.add_option("-c", "--connect", dest="server", help="Connect to a network server", metavar="SERVER")
group.add_option("-s", "--server", dest="server_players", type="int", help="Start a network server", metavar="PLAYERS")
parser.add_option_group(group)

group = OptionGroup(parser, "Game properties", ".")
group.add_option("-b", "--boardsize", dest="size", type="int", help="defines the board size [default: 8]", metavar="SIZE", default=8)
group.add_option("-w", "--wintarget", dest="win_target", type="int", help="Points needed to win [default: 150]", metavar="POINTS", default=150)
group.add_option("-o", "--winoffset", dest="win_offset", type="int", help="Offset needed to win [default: 15]", metavar="POINTS", default=15)
group.add_option("-t", "--timeout", dest="timeout", type="int", help="Timeout for each, 0 means indefinite [default: 0]", metavar="TIME", default=0)
parser.add_option_group(group)

(opt, args) = parser.parse_args()

# network client
if opt.server_players:
    s = Server(opt.size, opt.server_players, opt.win_target, opt.win_offset, opt.timeout)
    try:
        s.run()
    except KeyboardInterrupt:
        s.close()
# network server
elif opt.server:
    if len(args) < 1:
        print "At least one player should join the server. Please add players as parameter."
    else:
        c = Client(opt.server, args)
        Thread(target = c.run).start()

        cute.start_qt(c.game, c.local_player)

        c.socket.close()

        sys.exit(0)
# local game
else:
    if len(args) < 2:
        print "Please define at least 2 players as parameters"
    else:
        s = SquareGame(opt.size, args, opt.win_target, opt.win_offset)
        if opt.timeout:
            timer.BlitzSquare(s, opt.timeout)
        cute.start_qt(s)

