import QtQuick 1.1
import com.nokia.meego 1.0
import "file:///usr/lib/qt4/imports/com/nokia/meego/UIConstants.js" as UI

MenuItem {
    id: root

    property alias title: title.text
    property alias subTitle: subTitle.text

    Column {
        id: column

        anchors {
            left: parent.left
            leftMargin: UI.PADDING_DOUBLE
            right: icon.left
            rightMargin: UI.PADDING_DOUBLE
            verticalCenter: parent.verticalCenter
        }

        Label {
            id: title

            width: parent.width
            font.bold: true
            verticalAlignment: Text.AlignVCenter
            elide: Text.ElideRight
        }

        Label {
            id: subTitle

            width: parent.width
            font.pixelSize: UI.FONT_SMALL
            font.family: UI.FONT_FAMILY_LIGHT
            verticalAlignment: Text.AlignVCenter
            elide: Text.ElideRight
        }
    }

    Image {
        id: icon

        anchors {
            right: parent.right
            rightMargin: UI.PADDING_DOUBLE
            verticalCenter: parent.verticalCenter
        }

        source: "image://theme/icon-m-textinput-combobox-arrow"
    }
}
