/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef PODCASTEPISODELISTWINDOW_H
#define PODCASTEPISODELISTWINDOW_H

#include "stackedwindow.h"

class PodcastEpisodeFilterListModel;
class ListView;
class FilterBox;
class QLabel;
class QModelIndex;
class QVBoxLayout;

class PodcastEpisodeListWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit PodcastEpisodeListWindow(QWidget *parent = 0);

public slots:
    void showPodcastEpisodes(const QString &title, const QString &url);

    void clear();
    void reload();

private:
    void showEvent(QShowEvent *event);
    void keyPressEvent(QKeyEvent *event);

private slots:
    void onScrollingStopped();
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void showContextMenu(const QPoint &pos);
    void showPodcastEpisodeInfo();
    void onItemClicked(const QModelIndex &index);

private:
    ListView *m_view;
    PodcastEpisodeFilterListModel *m_model;
    FilterBox *m_filterBox;

    QMenu *m_contextMenu;
    QAction *m_infoAction;

    QLabel *m_noResultsLabel;

    QVBoxLayout *m_vbox;
};

#endif // PODCASTEPISODELISTWINDOW_H
