/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <QPainter>
#include <QMaemo5Style>
#include "podcastepisodelistdelegate.h"
#include "../base/podcastepisodelistmodel.h"

PodcastEpisodeListDelegate::PodcastEpisodeListDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void PodcastEpisodeListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    painter->save();

    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    QRect iconRect = option.rect;
    iconRect.setSize(QSize(64, 64));
    iconRect.moveTopLeft(QPoint(iconRect.left() + 8, iconRect.top() + 8));

    QImage logo = index.data(PodcastEpisodeListModel::LogoRole).value<QImage>();

    if (logo.isNull()) {
        logo = QImage("/usr/share/icons/hicolor/64x64/hildon/mediaplayer_default_stream.png");
    }

    painter->drawImage(iconRect, logo);

    QRect textRect = option.rect;
    textRect.moveTopLeft(QPoint(textRect.left() + 80, textRect.top() + 8));
    textRect.setHeight(32);
    textRect.setRight(textRect.right() - 8);

    painter->setClipRect(textRect);
    painter->drawText(textRect, Qt::AlignTop, index.data(PodcastEpisodeListModel::TitleRole).toString());

    textRect.moveTop(textRect.bottom());

    QFont smallFont;
    smallFont.setPixelSize(20);

    painter->setFont(smallFont);
    painter->setPen(QMaemo5Style::standardColor("SecondaryTextColor"));
    painter->setClipRect(textRect);
    painter->drawText(textRect, Qt::AlignBottom, index.data(PodcastEpisodeListModel::DescriptionRole).toString());

    painter->restore();
}

QSize PodcastEpisodeListDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 80);
}
