/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef PODCASTEPISODELIST_H
#define PODCASTEPISODELIST_H

#include <QNetworkReply>
#include "station.h"

class PodcastEpisodeList : public QObject
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ count
               NOTIFY finished)
    Q_PROPERTY(QNetworkReply::NetworkError error
               READ error
               NOTIFY finished)
    Q_PROPERTY(QString errorString
               READ errorString
               NOTIFY finished)

public:
    ~PodcastEpisodeList();

    int count() const;

    QList<Station*> results() const;

    QNetworkReply::NetworkError error() const;
    QString errorString() const;

public slots:
    void cancel();

private:
    explicit PodcastEpisodeList(QNetworkReply *reply, QObject *parent = 0);

private slots:
    void onReplyFinished();

signals:
    void canceled(PodcastEpisodeList *list);
    void finished(PodcastEpisodeList *list);

private:
    friend class Podcasts;

    QNetworkReply *m_reply;

    QList<Station*> m_results;
};

#endif
