/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.symbian 1.1

AppWindow {
    id: appWindow

    function playStation(station) {
        if (Settings.mediaPlayer == "cuteradio") {
            MediaPlayer.play(station);
            appWindow.pageStack.push(Qt.resolvedUrl("NowPlayingPage.qml"));
        }
        else if (Utils.urlIsPlaylist(station.source)) {
            StreamExtractor.getStreamUrl(station.source);
        }
        else {
            Launcher.launch(station.source);
        }
    }

    showStatusBar: true
    showToolBar: true
    initialPage: MainPage {
        id: mainPage
    }

    TitleHeader {
        id: titleHeader
    }

    MyInfoBanner {
        id: infoBanner
    }

    VolumeControl {
        id: volumeControl
    }

    ProgressDialog {
        id: progressDialog

        onRejected: StreamExtractor.cancelCurrentOperation()
    }

    Connections {
        target: StreamExtractor
        onBusy: progressDialog.showBusyMessage(message, numberOfOperations)
        onBusyProgressChanged: progressDialog.updateProgress(progress)
        onError: progressDialog.close()
    }
}
