/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.symbian 1.1
import com.cuteradio.models 1.0
import com.cuteradio.items 1.0
import com.cuteradio.enums 1.0

MyPage {
    id: root

    function searchPodcasts(query) {
        podcastModel.searchPodcasts(query);
    }

    function showPodcastsByGenre(genre) {
        podcastModel.showPodcastsByGenre(genre);
    }

    function showPodcastsByCountry(country) {
        podcastModel.showPodcastsByCountry(country);
    }

    function showPodcasts(url) {
        podcastModel.showPodcasts(url);
    }

    tools: ToolBarLayout {

        BackToolButton {}

        NowPlayingButton {}
    }

    MyListView {
        id: view

        property int selectedIndex: -1

        anchors.fill: parent
        model: TuneInPodcastListModel {
            id: podcastModel
        }
        delegate: TuneInPodcastDelegate {
            onClicked: {
                var page = appWindow.pageStack.push(Qt.resolvedUrl("TuneInPodcastEpisodeListPage.qml"), { title: title })
                page.showPodcastEpisodes(source);
            }

            onPressAndHold: {
                view.selectedIndex = -1;
                view.selectedIndex = index;
                contextMenu.open();
            }
        }
        onAtYEndChanged: if (atYEnd) podcastModel.getMoreResults();
    }

    MyScrollBar {
        flickableItem: view
    }

    Label {
        anchors {
            fill: parent
            margins: platformStyle.paddingLarge
        }
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        wrapMode: Text.WordWrap
        color: platformStyle.colorNormalMid
        font.bold: true
        font.pixelSize: 32
        text: qsTr("No podcasts found")
        visible: (!podcastModel.count) && (!podcastModel.loading)
    }

    BusyIndicator {
        anchors.centerIn: parent
        width: 64
        height: 64
        visible: (podcastModel.loading) && (!podcastModel.count)
        running: visible
    }

    ContextMenu {
        id: contextMenu

        MenuLayout {

            MenuItem {
                text: qsTr("Add to database")
                onClicked: {
                    dialogLoader.sourceComponent = addPodcastDialog;
                    dialogLoader.item.loadPodcast(podcastModel.get(view.selectedIndex));
                    dialogLoader.item.open();
                }
            }
        }

        onStatusChanged: if ((status === DialogStatus.Closed) && (root.status === PageStatus.Active)) view.forceActiveFocus();
    }

    Loader {
        id: dialogLoader
    }

    Component {
        id: addPodcastDialog

        TuneInAddPodcastDialog {
            onStatusChanged: {
                switch (status) {
                case DialogStatus.Closed:
                    if (root.status === PageStatus.Active) view.forceActiveFocus();
                    return;
                default:
                    return;
                }
            }
        }
    }
}
