/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.symbian 1.1
import com.cuteradio.models 1.0
import com.cuteradio.items 1.0
import com.cuteradio.enums 1.0

MyPage {
    id: root

    function showPodcastEpisodes(url) {
        episodeModel.showPodcastEpisodes(url);
    }

    tools: ToolBarLayout {

        BackToolButton {}

        NowPlayingButton {}
    }

    MyListView {
        id: view

        property int selectedIndex: -1

        anchors.fill: parent
        model: TuneInPodcastEpisodeListModel {
            id: episodeModel
        }
        delegate: TuneInPodcastEpisodeDelegate {
            onClicked: appWindow.playStation(episodeModel.get(index))

            onPressAndHold: {
                view.selectedIndex = -1;
                view.selectedIndex = index;
                contextMenu.open();
            }

        }
        onAtYEndChanged: if (atYEnd) episodeModel.getMoreResults();
    }

    MyScrollBar {
        flickableItem: view
    }

    Label {
        anchors {
            fill: parent
            margins: platformStyle.paddingLarge
        }
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        wrapMode: Text.WordWrap
        color: platformStyle.colorNormalMid
        font.bold: true
        font.pixelSize: 32
        text: qsTr("No episodes found")
        visible: (!episodeModel.count) && (!episodeModel.loading)
    }

    BusyIndicator {
        anchors.centerIn: parent
        width: 64
        height: 64
        visible: (episodeModel.loading) && (!episodeModel.count)
        running: visible
    }

    ContextMenu {
        id: contextMenu

        MenuLayout {

            MenuItem {
                text: qsTr("View info")
                onClicked: appWindow.pageStack.push(Qt.resolvedUrl("PodcastEpisodeInfoPage.qml")).loadPodcastEpisode(episodeModel.get(view.selectedIndex))
            }
        }

        onStatusChanged: if ((status === DialogStatus.Closed) && (root.status === PageStatus.Active)) view.forceActiveFocus();
    }
}
