import QtQuick 1.1
import com.nokia.meego 1.0

ToolButton {
    id: button

    platformStyle: ToolButtonStyle {
        textColor: Settings.activeColor
    }
    width: 300
    anchors.centerIn: parent
    iconSource: "images/" + (MediaPlayer.playing ? "play" : MediaPlayer.paused ? "pause" : "stop") + "-accent-" + Settings.activeColorString + ".png"
    text: MediaPlayer.currentStation ? !MediaPlayer.title ? MediaPlayer.currentStation.title : MediaPlayer.title : ""
    visible: MediaPlayer.currentStation !== null
    onClicked: appWindow.pageStack.push(Qt.resolvedUrl("NowPlayingPage.qml"))
}
