TEMPLATE = app
TARGET = cuteradio
QT += network sql xml

HEADERS += $$files(src/base/*.h)
SOURCES += $$files(src/base/*.cpp)

INSTALLS += target

maemo5 {
    system(lupdate src/base/*.* src/mediaplayer/mobility/*.* src/maemo5/*.* -ts translations/maemo5/base.ts)
    system(cp translations/maemo5/base.ts translations/maemo5/en.ts)
    system(lrelease translations/maemo5/en.ts)

    DEFINES += MOBILITY_PLAYER TUNE_IN
    QT += maemo5 dbus
    HEADERS += $$files(src/maemo5/*.h)
    SOURCES += $$files(src/maemo5/*.cpp)

    target.path = /opt/cuteradio/bin

    desktop.files = desktop/maemo5/cuteradio.desktop
    desktop.path = /usr/share/applications/hildon

    icon.files = desktop/maemo5/64x64/cuteradio.png
    icon.path = /usr/share/icons/hicolor/64x64/apps

    translations.files = $$files(translations/maemo5/*.qm)
    translations.path = /opt/cuteradio/translations

    INSTALLS += desktop icon translations
}

symbian {
    system(lupdate src/base/*.* src/mediaplayer/mobility/*.* src/symbian/*.* qml/symbian/*.qml -ts translations/symbian/base.ts)
    system(cp translations/symbian/base.ts translations/symbian/en.ts)
    system(lrelease translations/symbian/en.ts)

    TARGET = cuteradio_0xe71cbb8d
    DEFINES += QML_USER_INTERFACE MOBILITY_PLAYER TUNE_IN
    CONFIG += qtcomponents
    TARGET.UID3 = 0xE71CBB8D
    TARGET.CAPABILITY += NetworkServices ReadUserData
    INCLUDEPATH += MW_LAYER_SYSTEMINCLUDE
    LIBS += -L\\epoc32\\release\\armv5\\lib -lremconcoreapi
    LIBS += -L\\epoc32\\release\\armv5\\lib -lremconinterfacebase
    TARGET.EPOCHEAPSIZE = 0x20000 0x8000000
    TARGET.EPOCSTACKSIZE = 0x14000
    HEADERS += $$files(src/symbian/*.h) \
        $$files(src/qml/*.h) \
        $$files(src/symbian/volumekeys/*.h)
    SOURCES += $$files(src/symbian/*.cpp) \
        $$files(src/qml/*.cpp) \
        $$files(src/symbian/volumekeys/*.cpp)
    RESOURCES += qml/symbian/resources.qrc
    OTHER_FILES += $$files(qml/symbian/*.qml)

    DEPLOYMENT.display_name = cuteRadio
    VERSION = 0.2.1
    ICON = desktop/symbian/cuteradio.svg

    vendorinfo += "%{\"Stuart Howarth\"}" ":\"Stuart Howarth\""
    qtcomponentsdep = "; Default dependency to Qt Quick Components for Symbian library" \
        "(0x200346DE), 1, 1, 0, {\"Qt Quick components for Symbian\"}"

    my_deployment.pkg_prerules += vendorinfo qtcomponentsdep

    translations.files = $$files(translations/symbian/*.qm)
    translations.path = !:\\Private\\e71cbb8d\\translations

    DEPLOYMENT += my_deployment translations
}

simulator {
    DEFINES += QML_USER_INTERFACE MOBILITY_PLAYER TUNE_IN
    CONFIG += qtcomponents
    HEADERS += $$files(src/symbian/*.h)
    SOURCES += $$files(src/symbian/*.cpp)
    RESOURCES += qml/symbian/resources.qrc
    OTHER_FILES += $$files(qml/symbian/*.qml)
}

contains(MEEGO_EDITION,harmattan) {
    system(lupdate src/base/*.* src/mediaplayer/mobility/*.* src/harmattan/*.* qml/harmattan/*.qml -ts translations/harmattan/base.ts)
    system(cp translations/harmattan/base.ts translations/harmattan/en.ts)
    system(lrelease translations/harmattan/en.ts)

    DEFINES += QML_USER_INTERFACE MOBILITY_PLAYER TUNE_IN
    QT += opengl
    CONFIG += qdeclarative-boostable libcontentaction share-ui-common
    INCLUDEPATH += /usr/include/resource/qt4
    LIBS += -lresourceqt
    HEADERS += $$files(src/harmattan/*.h)
    SOURCES += $$files(src/harmattan/*.cpp)
    RESOURCES += qml/harmattan/resources.qrc
    OTHER_FILES += \
        qtc_packaging/debian_harmattan/rules \
        qtc_packaging/debian_harmattan/README \
        qtc_packaging/debian_harmattan/manifest.aegis \
        qtc_packaging/debian_harmattan/copyright \
        qtc_packaging/debian_harmattan/control \
        qtc_packaging/debian_harmattan/compat \
        qtc_packaging/debian_harmattan/changelog \
        qtc_packaging/debian_harmattan/postinst

    OTHER_FILES += $$files(qml/harmattan/*.qml)

    target.path = /opt/cuteradio/bin

    policy.files = policy/cuteradio.conf
    policy.path = /usr/share/policy/etc/syspart.conf.d

    desktop.files = desktop/harmattan/cuteradio.desktop
    desktop.path = /usr/share/applications

    icon.files = desktop/harmattan/80x80/cuteradio.png
    icon.path = /usr/share/icons/hicolor/80x80/apps

    splash.files = $$files(desktop/harmattan/splash/*.png)
    splash.path = /opt/cuteradio/splash

    translations.files = $$files(translations/harmattan/*.qm)
    translations.path = /opt/cuteradio/translations

    INSTALLS += desktop icon splash policy translations
}

contains(DEFINES,QML_USER_INTERFACE) {
    QT += declarative
} else {
    HEADERS += $$files(src/thumbnailcache/*.h)
    SOURCES += $$files(src/thumbnailcache/*.cpp)
}

contains(DEFINES,TUNE_IN) {
    HEADERS += $$files(src/tunein/*.h)
    SOURCES += $$files(src/tunein/*.cpp)
}

contains(DEFINES,MOBILITY_PLAYER) {
    maemo5 {
        CONFIG += mobility12
    } else {
        CONFIG += mobility
    }

    MOBILITY += multimedia
    HEADERS += src/mediaplayer/mobility/mediaplayer.h
    SOURCES += src/mediaplayer/mobility/mediaplayer.cpp

} else {
    QT += phonon
    HEADERS += src/mediaplayer/phonon/mediaplayer.h
    SOURCES += src/mediaplayer/phonon/mediaplayer.cpp
}
