/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef TUNEINPODCASTEPISODELISTMODEL_H
#define TUNEINPODCASTEPISODELISTMODEL_H

#include <QAbstractListModel>
#include "../base/station.h"

class TuneInPodcastEpisodeList;
#ifndef QML_USER_INTERFACE
class ThumbnailCache;
#endif

class TuneInPodcastEpisodeListModel : public QAbstractListModel
{
    Q_OBJECT
    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(bool moreResults
               READ moreResults
               NOTIFY loadingChanged)
    Q_PROPERTY(QUrl nextUrl
               READ nextUrl
               NOTIFY loadingChanged)
    Q_PROPERTY(bool loading
               READ loading
               NOTIFY loadingChanged)

public:
    enum Roles {
        ServiceRole = Qt::UserRole + 1,
        IdRole,
        TitleRole,
        DescriptionRole,
        LogoRole,
        GenreRole,
        CountryRole,
        LanguageRole,
        SourceRole,
        FavouriteRole,
        LastPlayedRole,
        SectionRole
    };

    explicit TuneInPodcastEpisodeListModel(QObject *parent = 0);
    ~TuneInPodcastEpisodeListModel();

#if QT_VERSION >= 0x050000
    QHash<int, QByteArray> roleNames() const;
#endif

    int rowCount(const QModelIndex &parent = QModelIndex()) const;

    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
    bool setData(const QModelIndex &index, const QVariant &value, int role);
    Q_INVOKABLE bool setData(int row, const QVariant &value, const QByteArray &role);

    bool moreResults() const;

    QUrl nextUrl() const;

    bool loading() const;

    Station* get(const QModelIndex &index) const;
    Q_INVOKABLE Station* get(int row) const;

public slots:
    void showPodcastEpisodes(const QString &url);

    void getMoreResults();

    void clear();
    void reload();

protected:
    void setNextUrl(const QUrl &url);

    void setLoading(bool loading);

protected slots:
    void onPodcastEpisodeListFinished(TuneInPodcastEpisodeList *list);
    void onPodcastEpisodeListCanceled(TuneInPodcastEpisodeList *list);

    void addPodcastEpisodes(QList<Station*> episodes);
    void addPodcastEpisode(Station *podcast);
    void insertPodcastEpisode(int row, Station *episode);
    void removePodcastEpisode(int row);
    void removePodcastEpisode(int role, const QVariant &value);
    void onPodcastEpisodeUpdated(const QString &id, const QVariantMap &properties);
    void onPodcastEpisodeUpdated(const QString &id, const QString &property, const QVariant &value);
    void onPodcastEpisodeDeleted(const QString &id);
#ifndef QML_USER_INTERFACE
    void onThumbnailReady();
#endif

signals:
    void countChanged(int count);
    void loadingChanged(bool loading);
    void error(const QString &errorString);

private:
#ifndef QML_USER_INTERFACE
    ThumbnailCache *m_cache;
#endif
    QList<Station*> m_list;

    QUrl m_nextUrl;

    bool m_loading;

    QHash<int, QByteArray> m_roleNames;
};

#endif // TUNEINPODCASTEPISODELISTMODEL_H
