/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef PODCASTEPISODEINFOWINDOW_H
#define PODCASTEPISODEINFOWINDOW_H

#include "stackedwindow.h"

class QUrl;
class Station;
class QLabel;
class ScrollArea;
class LogoLabel;

class PodcastEpisodeInfoWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit PodcastEpisodeInfoWindow(Station *episode, QWidget *parent = 0);

private slots:
    void playEpisode();

    void setLogo();

    void onLastPlayedChanged(qint64 lastPlayed);

    void onCurrentStationChanged(Station *station);

private:
    Station *m_episode;

    QAction *m_playAction;

    QLabel *m_descriptionLabel;
    QLabel *m_genreLabel;
    QLabel *m_countryLabel;
    QLabel *m_languageLabel;
    QLabel *m_sourceLabel;
    QLabel *m_lastPlayedLabel;

    LogoLabel *m_logoLabel;

    ScrollArea *m_scrollArea;
};

#endif // PODCASTEPISODEINFOWINDOW_H
