/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef PAIRLISTMODEL_H
#define PAIRLISTMODEL_H

#include <QSortFilterProxyModel>
#include <QStandardItemModel>
#include "enums.h"

class PairListModel : public QSortFilterProxyModel
{
    Q_OBJECT
    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(bool loading
               READ loading
               NOTIFY loadingChanged)
    Q_PROPERTY(QString query
               READ query
               WRITE setQuery
               NOTIFY queryChanged)
    Q_PROPERTY(Queries::QueryType queryType
               READ queryType
               NOTIFY queryTypeChanged)
#if (defined QML_USER_INTERFACE) && (!defined Q_WS_MAEMO_5)
    Q_PROPERTY(QString highlightColor
               READ highlightColor
               WRITE setHighlightColor)
#endif

public:
    enum Roles {
        NameRole = Qt::DisplayRole,
        CountRole = Qt::UserRole + 1,
        QueryMatchRole,
        SectionRole
    };

    explicit PairListModel(QObject *parent = 0);
    ~PairListModel();

#if QT_VERSION >= 0x050000
    QHash<int, QByteArray> roleNames() const;
#endif

    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;

    bool loading() const;

    QString query() const;

    Queries::QueryType queryType() const;

#if (defined QML_USER_INTERFACE) && (!defined Q_WS_MAEMO_5)
    QString highlightColor() const;
    void setHighlightColor(const QString &color);
#endif

public slots:
    void setQuery(const QString &query);

    void showGenres();
    void showCountries();
    void showLanguages();
    void clear();
    void reload();

protected:
    void setLoading(bool loading);

    void setQueryType(Queries::QueryType queryType);

    QString queryMatch(QString str) const;

protected slots:
    void addPairs(QList< QPair<QString, int> > pairs);
    void addPair(QPair<QString, int> pair);
    void removePair(const QModelIndex &index);
    void removePair(int row);
    void onItemAdded(const QString &name, int count);
    void onItemUpdated(const QString &name, int count);
    void onItemDeleted(const QString &name);

signals:
    void countChanged(int count);
    void loadingChanged(bool loading);
    void queryChanged(const QString &query);
    void queryTypeChanged(Queries::QueryType queryType);
    void highlightColorChanged(const QString &color);

protected:
    QStandardItemModel *m_model;

    QString m_query;

    bool m_loading;

    Queries::QueryType m_queryType;
#if (defined QML_USER_INTERFACE) && (!defined Q_WS_MAEMO_5)
    QString m_highlight;
#endif
    QHash<int, QByteArray> m_roleNames;
};

#endif // PAIRLISTMODEL_H
