import QtQuick 1.1
import com.nokia.symbian 1.1

ToolButton {
    id: root

    anchors.centerIn: parent
    flat: false
    iconSource: "images/" + (MediaPlayer.playing ? "play" : MediaPlayer.paused ? "pause" : "stop") + "-accent-" + Settings.activeColorString + ".png"
    text: MediaPlayer.currentStation ? !MediaPlayer.title ? MediaPlayer.currentStation.title : MediaPlayer.title : ""
    visible: MediaPlayer.currentStation !== null
    onClicked: appWindow.pageStack.push(Qt.resolvedUrl("NowPlayingPage.qml"))
    onTextChanged: internal.resetButton()
    onVisibleChanged: internal.resetButton()
    onWidthChanged: if (width != 240) internal.resetButton();
    Component.onCompleted: internal.resetButton()

    QtObject {
        id: internal

        function resetButton() {
            root.width = 240
        }
    }
}
