/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.meego 1.0
import com.cuteradio.models 1.0
import com.cuteradio.enums 1.0
import "file:///usr/lib/qt4/imports/com/nokia/meego/UIConstants.js" as UI

MyPage {
    id: root

    function showNames(id, filter) {
        nameModel.showNames(id, filter);
    }

    function showPodcastNames(id, filter) {
        nameModel.showPodcastNames(id, filter);
    }

    tools: ToolBarLayout {

        BackToolIcon {}

        NowPlayingButton {}
    }

    ListView {
        id: view

        anchors.fill: parent
        cacheBuffer: 400
        model: TuneInPairListModel {
            id: nameModel
        }
        delegate: TuneInNameDelegate {
            onClicked: {
                switch (nameModel.queryType) {
                case Queries.PodcastNames:
                    appWindow.pageStack.push(Qt.resolvedUrl("TuneInPodcastListPage.qml"), { title: name }).showPodcasts(value);
                    return;
                default:
                    appWindow.pageStack.push(Qt.resolvedUrl("TuneInStationListPage.qml"), { title: name }).showStations(value);
                    return;
                }
            }
        }
    }

    ScrollDecorator {
        flickableItem: view
    }

    Label {
        anchors {
            fill: parent
            margins: UI.PADDING_DOUBLE
        }
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        wrapMode: Text.WordWrap
        color: UI.COLOR_INVERTED_SECONDARY_FOREGROUND
        font.bold: true
        font.pixelSize: 40
        text: nameModel.queryType === Queries.PodcastNames ? qsTr("No podcasts found") : qsTr("No stations found")
        visible: (!nameModel.count) && (!nameModel.loading)
    }

    BusyIndicator {
        anchors.centerIn: parent
        platformStyle: BusyIndicatorStyle {
            size: "large"
        }
        visible: nameModel.loading
        running: visible
    }
}
