/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.meego 1.0
import "file:///usr/lib/qt4/imports/com/nokia/meego/UIConstants.js" as UI

Item {
    id: root

    height: 150

    Rectangle {
        id: background

        anchors.fill: parent
        color: UI.COLOR_INVERTED_SECONDARY_FOREGROUND
        opacity: mouseArea.pressed ? 0.5 : 0.8
    }

    Column {
        id: column

        anchors {
            left: parent.left
            right: parent.right
            top: parent.top
            margins: UI.PADDING_DOUBLE
        }
        spacing: UI.PADDING_DOUBLE

        Label {
            width: parent.width
            font.pixelSize: UI.FONT_SMALL
            color: UI.COLOR_FOREGROUND
            elide: Text.ElideRight
            text: (!MediaPlayer.currentStation) || (!MediaPlayer.currentStation.title) ? MediaPlayer.title : MediaPlayer.currentStation.title
        }

        Rectangle {
            height: 1
            width: parent.width
            color: UI.COLOR_FOREGROUND
        }

        Item {
            width: parent.width
            height: 100

            Column {
                anchors {
                    top: parent.top
                    left: parent.left
                    right: playButton.left
                    rightMargin: UI.PADDING_DOUBLE
                }
                spacing: UI.PADDING_DOUBLE

                Label {
                    width: parent.width
                    font.pixelSize: UI.FONT_SMALL
                    color: UI.COLOR_FOREGROUND
                    elide: Text.ElideRight
                    text: MediaPlayer.title
                }

                Label {
                    width: parent.width
                    font.pixelSize: UI.FONT_SMALL
                    color: UI.COLOR_FOREGROUND
                    elide: Text.ElideRight
                    text: MediaPlayer.artist
                }
            }

            MyButton {
                id: playButton

                width: 100
                height: 70
                anchors {
                    top: parent.top
                    right: parent.right
                }
                iconSource: MediaPlayer.playing ? "image://theme/icon-m-toolbar-mediacontrol-stop-white"
                                                : "image://theme/icon-m-toolbar-mediacontrol-play-white"
                onClicked: MediaPlayer.playing ? MediaPlayer.stop() : MediaPlayer.play()
            }
        }
    }

    MouseArea {
        id: mouseArea

        property int xPos
        property int yPos

        z: -1
        anchors.fill: parent
        onClicked: appWindow.pageStack.push(Qt.resolvedUrl("NowPlayingPage.qml"))
        onPressed: {
            xPos = mouseX;
            yPos = mouseY;
        }
        onReleased: if ((Math.abs(mouseX - xPos) < 20) && ((mouseY - yPos) > 40)) MediaPlayer.clear();
    }
}
