/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef ENUMS_H
#define ENUMS_H

#include <QObject>
#include <QNetworkProxy>

class Queries : public QObject
{
    Q_OBJECT
    Q_ENUMS(QueryType)

public:
    enum QueryType {
        StationSearch = 0,
        FavouriteStations,
        RecentlyPlayedStations,
        Genres,
        Countries,
        Languages,
        Recordings,
        Unknown
    };
};

class ScreenOrientation : public QObject
{
    Q_OBJECT
    Q_ENUMS(Orientation)

public:
    enum Orientation {
        Automatic = 0,
        LockPortrait,
        LockLandscape
    };
};

class NetworkProxyType : public QObject
{
    Q_OBJECT
    Q_ENUMS(ProxyType)

public:
    enum ProxyType {
        Socks5Proxy = QNetworkProxy::Socks5Proxy,
        HttpProxy = QNetworkProxy::HttpProxy,
        HttpCachingProxy = QNetworkProxy::HttpCachingProxy
    };
};

class PlaybackMode : public QObject
{
    Q_OBJECT
    Q_ENUMS(Mode)

public:
    enum Mode {
        Radio = 0,
        Sequential,
        RepeatAll,
        RepeatOne
    };
};

#endif // ENUMS_H
