/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.symbian 1.1
import com.cuteradio.enums 1.0

Item {
    id: root

    height: 70

    Rectangle {
        id: background

        anchors.fill: parent
        color: platformStyle.colorDisabledMid
        opacity: mouseArea.pressed ? 0.5 : 0.8
    }

    Label {
        anchors {
            left: parent.left
            leftMargin: platformStyle.paddingLarge
            right: playButton.left
            rightMargin: platformStyle.paddingLarge
            verticalCenter: parent.verticalCenter
        }
        font.pixelSize: platformStyle.fontSizeSmall
        color: platformStyle.colorNormalLight
        elide: Text.ElideRight
        text: MediaPlayer.currentStation.title + " | " + MediaPlayer.title + " | " + MediaPlayer.artist
    }

    MyButton {
        id: playButton

        width: 100
        anchors {
            right: parent.right
            rightMargin: platformStyle.paddingLarge
            verticalCenter: parent.verticalCenter
        }
        iconSource: MediaPlayer.playing ? "image://theme/toolbar-mediacontrol-" + (MediaPlayer.playbackMode === PlaybackMode.Radio ? "stop" : "pause")
                                        : "image://theme/toolbar-mediacontrol-play"
        onClicked: MediaPlayer.playing ? MediaPlayer.playbackMode !== PlaybackMode.Radio ? MediaPlayer.pause() : MediaPlayer.stop() : MediaPlayer.play()
    }

    MouseArea {
        id: mouseArea

        z: -1
        anchors.fill: parent
        onClicked: appWindow.pageStack.push(Qt.resolvedUrl("NowPlayingPage.qml"))
    }
}
