/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.meego 1.0
import "file:///usr/lib/qt4/imports/com/nokia/meego/UIConstants.js" as UI

Item {
    id: root

    height: 70

    Rectangle {
        id: background

        anchors.fill: parent
        color: UI.COLOR_INVERTED_SECONDARY_FOREGROUND
        opacity: mouseArea.pressed ? 0.5 : 0.8
    }

    Label {
        anchors {
            left: parent.left
            leftMargin: UI.PADDING_DOUBLE
            right: playButton.left
            rightMargin: UI.PADDING_DOUBLE
            verticalCenter: parent.verticalCenter
        }
        font.pixelSize: UI.FONT_SMALL
        color: UI.COLOR_FOREGROUND
        elide: Text.ElideRight
        text: MediaPlayer.currentStation.title + " | " + MediaPlayer.title + " | " + MediaPlayer.artist
    }

    MyButton {
        id: playButton

        width: 100
        anchors {
            right: parent.right
            rightMargin: UI.PADDING_DOUBLE
            verticalCenter: parent.verticalCenter
        }
        iconSource: MediaPlayer.playing ? "image://theme/icon-m-toolbar-mediacontrol-stop-white"
                                        : "image://theme/icon-m-toolbar-mediacontrol-play-white"
        onClicked: MediaPlayer.playing ? MediaPlayer.stop() : MediaPlayer.play()
    }

    MouseArea {
        id: mouseArea

        z: -1
        anchors.fill: parent
        onClicked: appWindow.pageStack.push(Qt.resolvedUrl("NowPlayingPage.qml"))
    }
}
