/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.symbian 1.1

ListHeading {
    id: root

    z: 1000
    height: 40
    anchors {
        left: parent.left
        right: parent.right
        top: parent.top
    }
    parent: appWindow.pageStack
    opacity: (appWindow.pageStack.currentPage === null) || (!appWindow.pageStack.currentPage.title) ? 0 : 1

    Behavior on opacity { NumberAnimation { duration: 200 } }

    Rectangle {
        height: 1
        anchors {
            left: parent.left
            right: parent.right
            bottom: parent.bottom
        }
        color: Settings.activeColor
        opacity: 0.5
    }

    Label {
        id: title

        anchors {
            left: parent.left
            leftMargin: platformStyle.paddingLarge
            verticalCenter: parent.verticalCenter
            right: parent.right
            rightMargin: platformStyle.paddingLarge
        }
        font.bold: true
        elide: Text.ElideRight
        text: appWindow.pageStack.currentPage === null ? "" : appWindow.pageStack.currentPage.title
    }

    MouseArea {
        anchors.fill: parent
    }
}
