#include "currencyedit.h"
#include "ui_currencyedit.h"

CurrencyEdit::CurrencyEdit(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::CurrencyEdit)
{
    ui->setupUi(this);
    updateList();
    ui->lineEdit_rate->setValidator(new QDoubleValidator(0, 9999999, 6, this));
}

CurrencyEdit::~CurrencyEdit()
{
    delete ui;
}

void CurrencyEdit::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void CurrencyEdit::updateList()
{
    mvSettings.beginGroup("Currency");
    QStringList allCurrencies = mvSettings.allKeys();
    QString currencyName;
    QStringList currencyNames;
    mvSettings.endGroup();

    mvSettings.beginGroup("CurrencyName");
    foreach (QString currency, allCurrencies) {
        currencyName = currency + " - " + mvSettings.value(currency).toString();
        currencyNames += currencyName;
    }
    mvSettings.endGroup();

    ui->listWidget->clear();
    ui->listWidget->addItems(currencyNames);
}

void CurrencyEdit::clearFields()
{
    ui->lineEdit_currency->clear();
    ui->lineEdit_description->clear();
    ui->lineEdit_rate->clear();
}

void CurrencyEdit::on_listWidget_clicked(QModelIndex index)
{
    QString selection = ui->listWidget->currentItem()->text().left(3);

    ui->lineEdit_currency->setText(selection);
    ui->lineEdit_description->setText(mvSettings.value("CurrencyName/" + selection).toString());
    ui->lineEdit_rate->setText(mvSettings.value("Currency/" + selection).toString());
    ui->pushButton_Add->setText("Modify");
}

void CurrencyEdit::on_pushButton_Add_clicked()
{
    QString currency = ui->lineEdit_currency->text();

    if (currency != "EUR") {
        mvSettings.setValue("CurrencyName/" + currency, ui->lineEdit_description->text());
        mvSettings.setValue("Currency/" + currency, ui->lineEdit_rate->text());
        updateList();
        clearFields();
        ui->pushButton_Add->setText("Add");
    }
}

void CurrencyEdit::on_pushButton_Remove_clicked()
{
    QString currency = ui->lineEdit_currency->text();

    if (currency != "EUR" and currency != "") {
        mvSettings.remove("CurrencyName/" + currency);
        mvSettings.remove("Currency/" + currency);
        if  (mvSettings.value("Currency1") == currency) {
            mvSettings.setValue("Currency1", "EUR");
        }
        if  (mvSettings.value("Currency2") == currency) {
            mvSettings.setValue("Currency2", "EUR");
        }

        QString keyHome;
        QString keyForeign;
        QString presetHome;
        QString presetForeign;
        int countPreset = mvSettings.value("CurrencyPreset").toInt();

        mvSettings.beginGroup("CurrencyPreset");
        for (int current = 0; current < countPreset; current++) {
            keyHome = QString::number(current) + "Home";
            keyForeign = QString::number(current) + "Foreign";
            presetHome = mvSettings.value(keyHome).toString();
            presetForeign = mvSettings.value(keyForeign).toString();
            if (presetHome == currency) {
                mvSettings.setValue(keyHome, "EUR");
            } else if (presetForeign == currency) {
                mvSettings.setValue(keyForeign, "EUR");
            }
        }
        mvSettings.endGroup();

        updateList();
        clearFields();
    }
}

void CurrencyEdit::on_pushButton_Restore_clicked()
{
    QMessageBox::StandardButton reply;
    reply = QMessageBox::warning(this, tr("Warning!"),
                                  "You will lose all your custom settings and " \
                                  "everything will be restored to default. " \
                                  "Are you sure?",
                                  QMessageBox::Yes | QMessageBox::No);
    if (reply == QMessageBox::Yes) {
        mvSettings.remove("");
        mvSettings.setValue("Restore", true);
        this->close();
    }
}

void CurrencyEdit::on_pushButton_Close_clicked()
{
    mvSettings.sync();
    this->close();
}
