#include "currency.h"
#include "ui_currency.h"

Currency::Currency(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Currency)
{
    ui->setupUi(this);

    ui->lineEdit_taxRate->setValidator(new QDoubleValidator(0, 100, 2, this));
    ui->lineEdit_tipRate->setValidator(new QDoubleValidator(0, 100, 2, this));
    ui->lineEdit_Currency1->setValidator(new QDoubleValidator(0, 9999999, 6, this));
    ui->lineEdit_Currency2->setValidator(new QDoubleValidator(0, 9999999, 6, this));
    ui->lineEdit_taxRate->setText(mvSettings.value("TaxRate").toString());
    ui->lineEdit_tipRate->setText(mvSettings.value("TipRate").toString());
    mvCurrency1 = mvSettings.value("Currency1").toString();
    mvCurrency2 = mvSettings.value("Currency2").toString();
    mvAutoUpdate = mvSettings.value("AutoUpdate").toBool();
    ui->checkBox_AutoUpdate->setChecked(mvAutoUpdate);

    displayRate();
    updateList();


}

Currency::~Currency()
{
    delete ui;
}

void Currency::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void Currency::displayRate()
{
    ui->lineEdit_Currency1->setText(mvSettings.value("Currency/" + mvCurrency1).toString());
    ui->lineEdit_Currency2->setText(mvSettings.value("Currency/" + mvCurrency2).toString());
    ui->label_Currency1->setText(mvCurrency1);
    ui->label_Currency2->setText(mvCurrency2);
    ui->listWidget1->sortItems(Qt::AscendingOrder);
    ui->listWidget2->sortItems(Qt::AscendingOrder);
}

void Currency::updateList()
{
    mvSettings.beginGroup("Currency");
    QStringList allCurrencies = mvSettings.allKeys();
    QString currencyName;
    QStringList currencyNames;
    mvSettings.endGroup();

    mvSettings.beginGroup("CurrencyName");
    foreach (QString currency, allCurrencies) {
        currencyName = currency + " - " + mvSettings.value(currency).toString();
        currencyNames += currencyName;
    }
    mvSettings.endGroup();

    ui->listWidget1->clear();
    ui->listWidget1->addItems(currencyNames);
    ui->listWidget2->clear();
    ui->listWidget2->addItems(currencyNames);
}

void Currency::on_listWidget1_clicked(QModelIndex index)
{
    mvCurrency1 = ui->listWidget1->currentItem()->text().left(3);
    displayRate();
}

void Currency::on_listWidget2_clicked(QModelIndex index)
{
    mvCurrency2 = ui->listWidget2->currentItem()->text().left(3);
    displayRate();
}

void Currency::on_pushButton_Apply_clicked()
{
    mvSettings.setValue("Currency1", mvCurrency1);
    mvSettings.setValue("Currency2", mvCurrency2);
    mvSettings.setValue("TaxRate", ui->lineEdit_taxRate->text().toDouble());
    mvSettings.setValue("TipRate", ui->lineEdit_tipRate->text().toDouble());
    mvSettings.setValue("AutoUpdate", mvAutoUpdate);

    if (mvCurrency1 != "EUR") {
        mvSettings.setValue("Currency/" + mvCurrency1, ui->lineEdit_Currency1->text().toDouble());
    }

    if (mvCurrency2 != "EUR") {
        mvSettings.setValue("Currency/" + mvCurrency2, ui->lineEdit_Currency2->text().toDouble());
    }

    mvSettings.sync();
    this->close();
}

void Currency::on_pushButton_Edit_clicked()
{
    editDialog = new Edit;
    editDialog->exec();
    mvCurrency1 = mvSettings.value("Currency1").toString();
    mvCurrency2 = mvSettings.value("Currency2").toString();
    displayRate();
    updateList();
}


void Currency::on_checkBox_AutoUpdate_clicked(bool checked)
{
    if (checked) {
        mvAutoUpdate = true;
    } else {
        mvAutoUpdate = false;
    }
}
