#include "currency.h"
#include "ui_currency.h"

Currency::Currency(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Currency)
{
    ui->setupUi(this);

    ui->lineEdit_taxRate->setValidator(new QIntValidator(0, 100, this));
    ui->lineEdit_tipRate->setValidator(new QIntValidator(0, 100, this));
    ui->lineEdit_taxRate->setText(mvSettings.value("TaxRate").toString());
    ui->lineEdit_tipRate->setText(mvSettings.value("TipRate").toString());
}

Currency::~Currency()
{
    delete ui;
}

void Currency::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void Currency::on_listWidget1_clicked(QModelIndex index)
{
    mvCurrency1 = ui->listWidget1->currentItem()->text();
}

void Currency::on_listWidget2_clicked(QModelIndex index)
{
    mvCurrency2 = ui->listWidget2->currentItem()->text();
}

void Currency::on_pushButton_Apply_clicked()
{
    mvSettings.setValue("Currency1", mvCurrency1.left(3));
    mvSettings.setValue("Currency2", mvCurrency2.left(3));
    mvSettings.setValue("TaxRate", ui->lineEdit_taxRate->text().toInt());
    mvSettings.setValue("TipRate", ui->lineEdit_tipRate->text().toInt());
    mvSettings.sync();
    this->close();
}
