/*
 *  CUE Sheet Widget for Maemo.
 *  Copyright (C) 2009 Roman Moravcik
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef CUESHEET_WIDGET_H
#define CUESHEET_WIDGET_H

#include <glib-object.h>
#include <libhildondesktop/libhildondesktop.h>

#define DATADIR "/usr/share"

G_BEGIN_DECLS

typedef struct _CueSheetWidget CueSheetWidget;
typedef struct _CueSheetWidgetClass CueSheetWidgetClass;

#define CUEMUSIC_TYPE_DESKTOP_APPLET (cuesheet_widget_get_type ())

#define CUESHEET_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                              CUEMUSIC_TYPE_DESKTOP_APPLET, CueSheetWidget))

#define CUESHEET_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), \
                                      CUEMUSIC_TYPE_DESKTOP_APPLET, CueSheetWidgetClass))

#define CUEMUSIC_IS_DESKTOP_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                                         CUEMUSIC_TYPE_DESKTOP_APPLET))

#define CUEMUSIC_IS_DESKTOP_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                                                 CUEMUSIC_TYPE_DESKTOP_APPLET))

#define CUESHEET_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                                        CUEMUSIC_TYPE_DESKTOP_APPLET, CueSheetWidgetClass))

struct _CueSheetWidget
{
	HDHomePluginItem hitem;

	osso_context_t* osso;

	MafwRegistry *registry;
	MafwRenderer *renderer;
	MafwSource *source;
	GList *track_list;

	guint timer;

	GtkWidget *performer;
	GtkWidget *title;
	GtkWidget *pannable;
	cairo_surface_t* background;

	gboolean cuesheet_available;
	gint current_track;
};

struct _CueSheetWidgetClass
{
	HDHomePluginItemClass parent_class;
};

GType cuesheet_widget_get_type(void);

G_END_DECLS

#endif
