import QtQuick 1.0

// Grundlegende Oberfläche mit Toolbar, Menü etc. -------------------------------------------------
Workspace { //Grundsätzliche Arbeitsfläche aus (Workspace.qml)
    id: workspace

    Toolbar{//Toolbar mit Harmattan Design (Toolbar.qml)
        id: toolbar
    }

    Toolbar_Item1{ // Button an erster Stelle in der Toolbar. Hier: connected mit Python - erneuert die Verdrehungsanweisung (Toolbar_Item1.qml)
        id: item1

        Image {
            source: "reload.png"
            anchors.centerIn: parent
        }

        }

    Toolbar_Menu { // Menü Button ganz rechts (Toolbar_Item_Menu.qml)
        id: menu_button
    }

    Settings { // Settings-Fenster, wird als State verwendet und "wartet" rechts vom Hauptfenster (Settings.qml)
        id: settings
    }

    Menu { // Menü, welches durch drücken des selbigen Buttons erscheint (Menu.qml)
        id: menu
    }

// States und Transitions der Oberfläche ----------------------------------------------------------

    states: [ // States der App, 1x Menü (von MenüButton), 1x Settingsfenster
        State {
            name: "menu"
            PropertyChanges {
                target: menu
                y: 0
            }
        },

            State {
                name: "settings"
                PropertyChanges {
                    target: menu
                    y: 800
                }

                PropertyChanges {
                    target: settings
                    x: 0
                }
            },

            State {
                name: "settings2normal"
                PropertyChanges {
                    target: settings
                    x: 480
                }
            },

            State {
                name: "menu2normal"
                PropertyChanges {
                    target: menu
                    y: 800
                }
            }
    ]

    transitions: [ // Transitions der States
        Transition {
            NumberAnimation {
                properties: "y"; easing.type: Easing.OutQuart; duration: 700;
            }
            NumberAnimation {
                properties: "x"; easing.type: Easing.InBack; duration: 700
            }
        }
    ]


    //-----------Verschiedene Funktionen um QML UI Elemente zu beeinflussen ----------


    // Update des Textstrings,für die Scramble-Anweisung-Zeile 1
    function scrambler(str) {
            scramble.text = str
    }

    // Update des Textstrings,für die Scramble-Anweisung-Zeile 2
    function scrambler2(str) {
            scramble2.text = str
    }

    // Update der Uhr-Anzeige
    function timerUpdate(str) {
        timer.text = str
    }

    // Update der Record-Zeit
    function record_time(str) {
        record.text = str
    }

    // Update der Average-Zeit
    function average_time(str) {
        average.text = str
    }

    // Update der Last-Zeit
    function last_time(str) {
        last.text = str
    }

    //Stopwatch-Settings Funktion: Wenn die Stopuhr aktiviert wurde, wird dies durch Python gespeichert.
    //Um die entsprechenden Ausblendungen auf der UI zu erzeugen dient uns diese Funktion!
    function stopwatchsetting(str) {
        if (str == "True") {
        settings.opacity_stopwatch = 1.0; //ist ein Alias der Settings.qml
        scramble_title.opacity = 0.0;
        scramble.opacity = 0.0;
        scramble2.opacity = 0.0;
        record.opacity = 0.0;
        average.opacity = 0.0;
        last.opacity = 0.0}

        else {
        settings.stopwatch_opacity = 0.0; //ist ein Alias der Settings.qml
        scramble_title.opacity = 1.0;
        scramble.opacity = 1.0;
        scramble2.opacity = 1.0;
        record.opacity = 1.0;
        average.opacity = 1.0;
        last.opacity = 1.0}
    }

    //Inspection-Settings Funktion: Wenn die Inspektions-Zeit aktiviert wurde, wird dies durch Python gespeichert.
    //Um die entsprechenden Ausblendungen auf der UI zu erzeugen dient uns diese Funktion!
    function inspectionsetting(str) {
        if (str == "True") {
        settings.opacity_waittime = 1.0; //ist ein Alias der Settings.qml
        }

        else {
        settings.stopwatch_opacity = 0.0; //ist ein Alias der Settings.qml
        }
    }

    //Ergänzende UI Elemente - speziell für diese App ---------------------------------------------

    Text { // Uhrzeit der Stopuhr
        id: timer
        objectName: "timer"
        anchors.centerIn: workspace
        text: "00:00:00"
        color: "#aaaaaa"
        font.family: "Nokia Pure Text Light"
        font.pointSize: 85
        z: 3
    }

    Rectangle { // connected mit Python - Start/Stop-"Button" der Uhr (unsichtbar)
        id: startstop
        x: 10
        y: 326
        anchors.centerIn: workspace
        width: workspace.width-20
        height: 220
        radius: 15
        color: "white"
        border.width: 2
        border.color: "#aaaaaa"

        MouseArea {
            id: timer_start
            objectName: "timer_start"
            anchors.fill: parent
            onReleased: {
                if (timer.color == "#5ab500"){timer.color = "#aaaaaa"}
                else {timer.color = "#5ab500"};
            }
        }
    }

    Text { // Titel der App selbst
        id: title
        anchors.horizontalCenter: parent.horizontalCenter
        anchors.top: parent.top
        anchors.topMargin: 20
        text: "CubeTimer QML"
        font.family: "Nokia Pure Text Light"
        font.pointSize: 32
        color: "#aaaaaa"
    }

    Text { // "Scramble:" Text
        id: scramble_title
        anchors.left: parent.left
        anchors.leftMargin: 20
        anchors.top: parent.top
        anchors.topMargin: 140
        text: "Scramble:"
        color: "#aaaaaa"
        font.pointSize: 18
        font.family: "Nokia Pure Text"
        opacity: 1.0
    }

    Text { // Reihe 1 der Scramble Anweisungen
        id: scramble
        anchors.horizontalCenter: parent.horizontalCenter
        anchors.top: scramble_title.top
        anchors.topMargin: 60
        text: "01  02  03  04  05  06  07  08  09  10  11  12  13  14  15"
        font.pointSize: 14
        font.family: "Nokia Pure Text"
        opacity: 1.0
    }

    Text { // Reihe 2 der Scramble Anweisungen
        id: scramble2
        anchors.horizontalCenter: parent.horizontalCenter
        anchors.top: scramble_title.top
        anchors.topMargin: 90
        text: "16  17  18  19  20  21  22  23  24  25  26  27  28  29  30"
        font.pointSize: 14
        font.family: "Nokia Pure Text"
        opacity: 1.0

    }

    Text { // Rekord-Zeit
        id: record
        objectName: "record"
        anchors.top: timer.bottom
        anchors.topMargin: 50
        x: 20
        text: "best: 00:06:94 min."
        color: "black"
        font.pointSize: 18
        font.family: "Nokia Pure Text"
        font.bold: true
        opacity: 1.0
    }

    Text { // durchschnittliche Zeit
        id: average
        objectName: "average"
        anchors.top: timer.bottom
        anchors.topMargin: 90
        x: 20
        text: "average: 00:17:57 min."
        color: "#5ab500"
        font.pointSize: 18
        font.family: "Nokia Pure Text"
        font.bold: true
        opacity: 1.0
    }

    Text { // letzte Zeit
        id: last
        objectName: "last"
        anchors.top: timer.bottom
        anchors.topMargin: 130
        x: 20
        text: "last: 00:26:00 min."
        font.pointSize: 18
        font.family: "Nokia Pure Text"
        font.bold: true
        color: "#5ab500"
        opacity: 1.0
    }

}

