#include <QtGui>
#include "mainwindow.h"
#include "ui_mainwindow.h"

mainwindow::mainwindow(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::mainwindow)
{
    QLocale::setDefault(QLocale(QLocale::English, QLocale::UnitedStates));
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);

    setAttribute(Qt::WA_Maemo5AutoOrientation, true);

    ui->setupUi(this);

    if (!QFile::exists("/opt/cssutransitionstuner/cssuinstalled")) {
        QMaemo5InformationBox::information(this, tr("Could not detect Community SSU being installed.<br /><br />You may still try to use the CSSU Tuner, but some functions may not have effect."), QMaemo5InformationBox::NoTimeout);
    }

    if (!QFile::exists("/opt/cssutransitionstuner/tactileinstalled")) {
        ui->tactile->setDisabled(true);
    }

    ui->buttonBox->button(QDialogButtonBox::Help)->setText(tr("About"));
    ui->buttonBox->button(QDialogButtonBox::Save)->setText(tr("Save"));
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
    orientationChanged();
    readvalues();
    abouttext = tr("Author: d-iivil<br />Licence: GPL");
    abouttitle = "CSSU Tuner " + tr("version") + " 0.1.9";
}

mainwindow::~mainwindow()
{
    delete ui;
}

void mainwindow::orientationChanged()
{
     QRect screenGeometry = QApplication::desktop()->screenGeometry();
     if (screenGeometry.width() > screenGeometry.height())
     {
	 ui->gridLayout->addWidget(ui->buttonBox, 0, 1, 1, 1);
     }
     else
     {
	 ui->gridLayout->addWidget(ui->buttonBox, 1, 0, 1, 1);
     }

}

void mainwindow::sed(QString speed, QString path)
{
    QProcess proc;
    proc.start("perl -pi -e \"s/duration=.*/duration=" + speed + "/g\" " + path);
    proc.waitForFinished();

    proc.start("perl -pi -e \"s/duration_in=.*/duration_in=" + speed + "/g\" " + path);
    proc.waitForFinished();

    proc.start("perl -pi -e \"s/duration_out=.*/duration_out=" + speed + "/g\" " + path);
    proc.waitForFinished();
}

void mainwindow::readvalues()
{
    QString path;

    if (QFile::exists("/etc/hildon/theme/transitions.ini")) {
        path = "/etc/hildon/theme/transitions.ini";
    } else {
        path = "/usr/share/hildon-desktop/transitions.ini";
    }

    QProcess proc;

    proc.start("gconftool-2 -g /apps/osso/maemo-statusmenu-fmtx/always_visible");
    proc.waitForReadyRead();
    QString fm = proc.readLine();
    fm.remove(" ");
    if (fm == "false\n") {
        ui->fm->setChecked(false);
    } else {
       ui->fm->setChecked(true);
    }
    proc.waitForFinished();

    proc.start("gconftool-2 -g /apps/osso/hildon-desktop/menu_edit_disabled");
    proc.waitForReadyRead();
    QString app = proc.readLine();
    app.remove(" ");
    if (app == "false\n") {
        ui->appmenu->setChecked(true);
    } else {
       ui->appmenu->setChecked(false);
    }
    proc.waitForFinished();

    proc.start("gconftool-2 -g /apps/osso/hildon-desktop/key-actions/disable_edit");
    proc.waitForReadyRead();
    QString home = proc.readLine();
    home.remove(" ");
    if (home == "false\n") {
        ui->homescreen->setChecked(true);
    } else {
       ui->homescreen->setChecked(false);
    }
    proc.waitForFinished();

    proc.start("gconftool-2 -g /apps/osso/hildon-status-menu/view/number_of_rows");
    proc.waitForReadyRead();
    QString items = proc.readLine();
    items.remove("\n");
    int itemsint = items.toInt();
    ui->items->setValue(itemsint);
    proc.waitForFinished();

    proc.start("gconftool-2 -g /apps/osso/hildon-status-menu/view/number_of_rows_portrait");
    proc.waitForReadyRead();
    items = proc.readLine();
    items.remove("\n");
    itemsint = items.toInt();
    ui->items_portait->setValue(itemsint);
    proc.waitForFinished();


    QSettings settings(path, QSettings::IniFormat);

    settings.beginGroup("thp_tweaks");

    if (settings.contains("blurless")) {
        QString blurless = settings.value("blurless").toString();
        if (blurless == "1") ui->blurless->setChecked(true);
    }

    if (settings.contains("taskswitcher")) {
        int taskswitcherint = settings.value("taskswitcher").toInt();
        ui->taskswitcher->setCurrentIndex(taskswitcherint);
    }

    if (settings.contains("zaxisrotation")) {
        QString zaxisrotation = settings.value("zaxisrotation").toString();
        if (zaxisrotation == "1") ui->zaxis->setChecked(true);
    }

    if (settings.contains("forcerotation")) {
        QString forcerotation = settings.value("forcerotation").toString();
        if (forcerotation == "1") ui->forcerotation->setChecked(true);
    }

    if (settings.contains("tactilepopups")) {
        QString tactilepopups = settings.value("tactilepopups").toString();
        if (tactilepopups == "1") ui->tactile->setChecked(true);
    }

     settings.endGroup();

     settings.beginGroup("home");

        if (settings.contains("zoom_on_press")) {
        QString zoom_on_press = settings.value("zoom_on_press").toString();
        if (zoom_on_press == "1") ui->zoomonpress->setChecked(true);
    }


        if (settings.contains("parallax")) {
        QString parallax = settings.value("parallax").toString();
        double parallaxdouble = parallax.toDouble();
        ui->parallax->setValue(parallaxdouble);
        }

        if (settings.contains("radius_more")) {
        QString radius_more = settings.value("radius_more").toString();
        int radius_moreint = radius_more.toInt();
        ui->blur->setValue(radius_moreint);
        }


     settings.endGroup();

     settings.beginGroup("launcher");

     if (settings.contains("deceleration_rate")) {
     QString deceleration_rate = settings.value("deceleration_rate").toString();
     double deceleration_ratesouble = deceleration_rate.toDouble();
     ui->scrollrate->setValue(deceleration_ratesouble);
     }


     settings.endGroup();

     settings.beginGroup("launcher_in");
     int speed = settings.value("duration").toInt();
     ui->speed->setValue(speed);
     settings.endGroup();

}

void mainwindow::storevalues()
{
    int speed = ui->speed->value();
    QString speedstring = QString::number(speed);

    QString path2 = "/usr/share/hildon-desktop/transitions.ini";

    if (QFile::exists("/etc/hildon/theme/transitions.ini")) {

    path2 = "/etc/hildon/theme/transitions.ini";
    system("perl -pi -e \"s/#/;/g\" /etc/hildon/theme/transitions.ini");

    sed(speedstring, path2);

    }

    QString path = "/usr/share/hildon-desktop/transitions.ini";
    system("perl -pi -e \"s/#/;/g\" /usr/share/hildon-desktop/transitions.ini");

    sed(speedstring, path);

    QString path3 = "/usr/share/hildon-desktop/transitions.ini";

    if (QFile::exists("/opt/theme-customizer/transitions.ini")) {
    path3 = "/opt/theme-customizer/transitions.ini";
    system("perl -pi -e \"s/#/;/g\" /opt/theme-customizer/transitions.ini");

    sed(speedstring, path3);

    }

    QSettings settings(path, QSettings::IniFormat);
    QSettings settings2(path2, QSettings::IniFormat);
    QSettings settings3(path3, QSettings::IniFormat);

    double parallaxint = ui->parallax->value();
    double deceleration_rateint = ui->scrollrate->value();

    double ylaraja = 1;
    double alaraja = -1;
    if (parallaxint <= ylaraja && parallaxint >= 0) {
        parallaxint = 1;
    } else if (parallaxint >= alaraja && parallaxint <= 0) {
        parallaxint = -1;
    }
    QString parallax = QString::number(parallaxint);
    parallax.replace(',', '.');

    QString deceleration_rate = QString::number(deceleration_rateint);
    deceleration_rate.replace(',', '.');

    int radius_moreint = ui->blur->value();
    QString radius_more = QString::number(radius_moreint);

    if ( ui->fm->checkState() == Qt::Checked ) {
	system("gconftool-2 -s /apps/osso/maemo-statusmenu-fmtx/always_visible -t bool true");
    } else {
	system("gconftool-2 -s /apps/osso/maemo-statusmenu-fmtx/always_visible -t bool false");
    }

    if ( ui->appmenu->checkState() == Qt::Checked ) {
	system("gconftool-2 -s /apps/osso/hildon-desktop/menu_edit_disabled -t bool false");
    } else {
	system("gconftool-2 -s /apps/osso/hildon-desktop/menu_edit_disabled -t bool true");
    }

    if ( ui->homescreen->checkState() == Qt::Checked ) {
	system("gconftool-2 -s /apps/osso/hildon-desktop/key-actions/disable_edit -t bool false");
    } else {
	system("gconftool-2 -s /apps/osso/hildon-desktop/key-actions/disable_edit -t bool true");
    }

    QProcess storeproc;
    QString intvalue = QString::number(ui->items->value());
    storeproc.start("gconftool-2 -s /apps/osso/hildon-status-menu/view/number_of_rows -t int " + intvalue);
    storeproc.waitForFinished();

    intvalue = QString::number(ui->items_portait->value());
    storeproc.start("gconftool-2 -s /apps/osso/hildon-status-menu/view/number_of_rows_portrait -t int " + intvalue);
    storeproc.waitForFinished();

    settings.beginGroup("thp_tweaks");

        if ( ui->blurless->checkState() == Qt::Checked ) {
            settings.setValue("blurless","1");
        } else {
            settings.setValue("blurless","0");
        }

        settings.setValue("taskswitcher", ui->taskswitcher->currentIndex());

        if ( ui->zaxis->checkState() == Qt::Checked ) {
            settings.setValue("zaxisrotation", "1");
        } else {
            settings.setValue("zaxisrotation", "0");
        }

        if ( ui->tactile->checkState() == Qt::Checked ) {
            settings.setValue("tactilepopups", "1");
        } else {
            settings.setValue("tactilepopups", "0");
        }

        if ( ui->forcerotation->checkState() == Qt::Checked ) {
            settings.setValue("forcerotation", "1");
        } else {
            settings.setValue("forcerotation", "0");
        }


     settings.endGroup();

     settings.beginGroup("home");

        if ( ui->zoomonpress->checkState() == Qt::Checked ) {
            settings.setValue("zoom_on_press", "1");
        } else {
            settings.setValue("zoom_on_press", "0");
        }

        settings.setValue("parallax", parallax);

        settings.setValue("radius_more", radius_more);

     settings.endGroup();

     settings.beginGroup("launcher");

     settings.setValue("deceleration_rate", deceleration_rate);
     settings.setValue("strong_deceleration_rate", "0.7");

     settings.endGroup();

     settings2.beginGroup("thp_tweaks");

         if ( ui->blurless->checkState() == Qt::Checked ) {
             settings2.setValue("blurless","1");
         } else {
             settings2.setValue("blurless","0");
         }

         settings2.setValue("taskswitcher", ui->taskswitcher->currentIndex());

         if ( ui->zaxis->checkState() == Qt::Checked ) {
             settings2.setValue("zaxisrotation", "1");
         } else {
             settings2.setValue("zaxisrotation", "0");
         }

         if ( ui->forcerotation->checkState() == Qt::Checked ) {
             settings2.setValue("forcerotation", "1");
         } else {
             settings2.setValue("forcerotation", "0");
         }

         if ( ui->tactile->checkState() == Qt::Checked ) {
             settings2.setValue("tactilepopups", "1");
         } else {
             settings2.setValue("tactilepopups", "0");
         }


      settings2.endGroup();

      settings2.beginGroup("home");

         if ( ui->zoomonpress->checkState() == Qt::Checked ) {
             settings2.setValue("zoom_on_press", "1");
         } else {
             settings2.setValue("zoom_on_press", "0");
         }


         settings2.setValue("parallax", parallax);

         settings2.setValue("radius_more", radius_more);

      settings2.endGroup();

      settings2.beginGroup("launcher");

      settings2.setValue("deceleration_rate", deceleration_rate);
      settings2.setValue("strong_deceleration_rate", "0.7");

      settings2.endGroup();

      settings3.beginGroup("thp_tweaks");

          if ( ui->blurless->checkState() == Qt::Checked ) {
              settings3.setValue("blurless","1");
          } else {
              settings3.setValue("blurless","0");
          }

          settings3.setValue("taskswitcher", ui->taskswitcher->currentIndex());

          if ( ui->zaxis->checkState() == Qt::Checked ) {
              settings3.setValue("zaxisrotation", "1");
          } else {
              settings3.setValue("zaxisrotation", "0");
          }

          if ( ui->forcerotation->checkState() == Qt::Checked ) {
              settings3.setValue("forcerotation", "1");
          } else {
              settings3.setValue("forcerotation", "0");
          }

          if ( ui->tactile->checkState() == Qt::Checked ) {
              settings3.setValue("tactilepopups", "1");
          } else {
              settings3.setValue("tactilepopups", "0");
          }


       settings3.endGroup();

       settings3.beginGroup("home");

          if ( ui->zoomonpress->checkState() == Qt::Checked ) {
              settings3.setValue("zoom_on_press", "1");
          } else {
              settings3.setValue("zoom_on_press", "0");
          }


          settings3.setValue("parallax", parallax);

          settings3.setValue("radius_more", radius_more);

       settings3.endGroup();

       settings3.beginGroup("launcher");

       settings3.setValue("deceleration_rate", deceleration_rate);
       settings3.setValue("strong_deceleration_rate", "0.7");

       settings3.endGroup();


}


void mainwindow::on_buttonBox_clicked(QAbstractButton* button)
{
    QDialogButtonBox::ButtonRole role=ui->buttonBox->buttonRole(button);
    switch(role)
    {
	case QDialogButtonBox::HelpRole:
	{
	    QMessageBox msgBox;
	    msgBox.setWindowTitle(abouttitle);
	    msgBox.setText(abouttext);
	    msgBox.exec();
	    break;
	}
	case QDialogButtonBox::AcceptRole:
	{
            storevalues();
	    QMessageBox msgBox;
            msgBox.setWindowTitle(tr("Transitions updated!"));
            msgBox.setText(tr("Reboot is required to activate all changes."));
	    msgBox.exec();
            readvalues();
	    break;
	}
	default:;
    }
}
