# -*- coding: utf-8 -*-
# Copyright (C) 2009 by Daniel Martin Yerga <dyerga@gmail.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# CasualServices: Search and share your favourite places

"""Module to manage the Maemo 5 agenda

Exported Classes:

Agenda -- Class to access to Maemo 5 agenda functions.

EContactAddress -- Class to define a EContactAddress object.

"""
import evolution
from ctypes import *

E_CONTACT_ADDRESS_WORK = 91

class Agenda:
    """Class to access to Maemo 5 agenda functions

    Public functions:
    add_contact --

    """
    def __init__(self):
        """Define some variables to use in some functions.

        """
        self.book = evolution.ebook.open_addressbook('default')
        self.ebook = CDLL('libebook-1.2.so.5')

    def add_contact(self, data):
        """Add a contact to the main Maemo 5 agenda.

        @type   data: list
        @param  data: list with the contact details (name, address, phone, etc.)

        @rtype: boolean
        @returns: True if everything is OK, False otherwise.

        """
        #data = [name, address, phone, locality, region, country, url, img]
        try:
            #print data
            contact = evolution.ebook.EContact()
            contact.set_property('full-name', data[0].__str__())
            contact.set_property('business-phone', data[2])
            contact.set_property("homepage-url", data[6].__str__())

            #TODO: photo

            self.book.add_contact(contact)

            address = EContactAddress()
            address.address_format = ''
            address.po = ''
            address.ext = ''
            address.street = data[1].__str__()
            address.locality = data[3].__str__()
            address.region = data[4].__str__()
            address.code = ''
            address.country = data[5].__str__()
            self.ebook.e_contact_set(hash(contact), E_CONTACT_ADDRESS_WORK,
                                    addressof(address))
            self.book.commit_contact(contact)

            return True
        except Exception, e:
            print "Error adding new contact: ", e
            return False

class EContactAddress(Structure):
    """Class to define a EContactAddress object.

    """
    _fields_ = [('address_format', c_char_p), ('po', c_char_p),
                ('ext', c_char_p), ('street', c_char_p),
                ('locality', c_char_p), ('region', c_char_p),
                ('code', c_char_p), ('country', c_char_p)]
