/*
* Linux screen handling...
* I use SDL for for the graphics part,
* and Hermes to stretch the image
* (oddy enough SDL doesn't appear to
* have any stretch-blit functionality?)
* Anyway... SDL uses some pre-
* processor magic that requiers
* pragma pack NOT to be used,
* at least not pack(1),
* unfortunately CSBTypes.h defines pack(1),
* so SDL is included in stdafx.h, before
* we define any pragma packing.
*/

#include "stdafx.h"
#include "UI.h"
#include <stdio.h>

#include "Objects.h"
#include "Dispatch.h"
#include "CSB.h"
#include "Data.h"
#include "CSBTypes.h"

// Linux screen handling

/**
 * If this is defined, the "old" blitter is used. Faster, but
 * does not support the overlay graphics and jitter (screen shake) effects.
 */
//#define OLD_BLITTER

extern SDL_Surface *WND;
extern i32 VBLMultiplier;
extern i16 globalPalette[16];
extern bool fullscreenRequested;
extern bool fullscreenActive;
extern bool overlayActive;
extern i32 xGraphicJitter;
extern i32 xOverlayJitter;
extern i32 yGraphicJitter;
extern bool jitterChanged;
ui32 STBLTCount=0;

extern i32 screenSize;
gboolean noDirtyRect = TRUE;
SDL_Rect DirtyRect;
i16 palette16[16];
i16 counter;
i32 dstLineLen;
static ui8 black[320]; //All zeros for one line of overlay
#ifdef OLD_BLITTER
typedef ui32 tPaletteColor;
#else // OLD_BLITTER
typedef i16 tPaletteColor;
#endif // OLD_BLITTER
static tPaletteColor palette1[16];
static tPaletteColor palette2[16];
static i16 oldPalette1[16];
static i16 oldPalette2[16];
pnt logbase(void);
#ifdef _DYN_WINSIZE
	i16 bitmap[320*4*200*4];
#	define wrBITMAP (ui32*)(bitmap)
	const int PALETTE_RED_BITS = 16;
	const int PALETTE_GREEN_BITS = 8;
	const int PALETTE_BLUE_BITS = 0;
#else // not _DUN_WINSIZE
	extern SDL_Surface * SCRAP;
#	define wrBITMAP (ui32*)(SCRAP->pixels)
	const int PALETTE_RED_BITS = 0;
	const int PALETTE_GREEN_BITS = 8;
	const int PALETTE_BLUE_BITS = 16; 
#endif

bool ForcedScreenDraw = false;
void ForceScreenDraw(void)
{
  ForcedScreenDraw = true;
}

bool IsTextScrollArea(i32, i32)
{
  return false;
}

void SwapTextZOrder(void)
{
  return;
}

static void createPalette32( i32 * palette32, i16 *palette);

/**
 * Add the given rectangle to the dirty area.
 * Coordinates are host screen coordinates.
 */
static void mkDirty(i32 x, i32 y, i32 w, i32 h) {
	if( noDirtyRect ) {
		DirtyRect.x = x; //CLAMP(x,0,320);
		DirtyRect.y = y; // CLAMP(y,0,200);
		DirtyRect.w = w; // CLAMP(w,0,320-DirtyRect.x);
		DirtyRect.h = h; // CLAMP(h,0,200-DirtyRect.y);
		noDirtyRect = FALSE;
	} else {
		i32 id_st_mouseXp = x + w;
		i32 id_st_mouseYp = y + h;
		i32 oldW = DirtyRect.x + DirtyRect.w;
		i32 oldH = DirtyRect.y + DirtyRect.h;
		DirtyRect.x = x <= DirtyRect.x ? x : DirtyRect.x ;
		DirtyRect.y = y <= DirtyRect.y ? y : DirtyRect.y ;
		DirtyRect.w = id_st_mouseXp >= oldW ? id_st_mouseXp - DirtyRect.x : oldW - DirtyRect.x ;
		DirtyRect.h = id_st_mouseYp >= oldH ? id_st_mouseYp - DirtyRect.y : oldH - DirtyRect.y ;
	}
}
#if 0
static void Well___SDL_must_not_be_included_with_pragma_pack(bool updatePalette) {
	const SDL_VideoInfo *info = SDL_GetVideoInfo();
#ifdef _DYN_WINSIZE
	if(updatePalette) {
		i32 *pal = Hermes_PaletteGet(from_palette);
		createPalette32( pal, palette1);
		//SDL_SetPalette(SCR, SDL_LOGPAL|SDL_PHYSPAL, palette32, 0, 16 );
		createPalette32( &pal[0x10], palette2);
		//SDL_SetPalette(SCR, SDL_LOGPAL|SDL_PHYSPAL, palette32, 16, 16 );
		Hermes_PaletteInvalidateCache(from_palette);
	}

	/*
	* According to Hermes documentation, this should take no time...
	*/
	HermesFormat to;
	to.has_colorkey = FALSE;
	to.indexed = (NULL != info->vfmt->palette);
	to.bits = info->vfmt->BitsPerPixel;
	to.r = info->vfmt->Rmask;
	to.g = info->vfmt->Gmask;
	to.b = info->vfmt->Bmask;
	to.a = info->vfmt->Amask;
	Hermes_ConverterRequest( converter, from_format, &to );
	if(updatePalette) {
		Hermes_ConverterPalette( converter, from_palette, to.indexed ? to_palette : NULL );
		if(to.indexed) Hermes_PaletteSet( to_palette, (i32*) info->vfmt->palette ); // FIXME: Little endian will not work here?
	}
#else
	if(updatePalette) {
		i32 pal[0x21];
		createPalette32( pal, palette1);
		createPalette32( &pal[0x10], palette2);
		SDL_SetPalette(SCRAP,SDL_LOGPAL|SDL_PHYSPAL,reinterpret_cast<SDL_Color*>(pal),0,0x20);
    }
#endif

	/*
	* And stretch it...
	*/
	SDL_Rect rect;
	SDL_GetClipRect(WND, &rect );
	const ui32 scZi = rect.w * info->vfmt->BytesPerPixel;
	i32 x,y,w,h;
	if(updatePalette) {
		x = rect.x;
		y = rect.y;
		w = rect.w;
		h = rect.h;
	} else {
		if( noDirtyRect ) {
			return;
		} else {
#ifdef _DYN_WINSIZE
			x = ((float) (DirtyRect.x - 160) ) / st_X + ((float)rect.w)/2.0 + 0.5;
			y = ((float) (DirtyRect.y - 100) ) / st_Y + ((float)rect.h)/2.0 + 0.5;
			w = ((float) (DirtyRect.w) ) / st_X + 0.5;
			h = ((float) (DirtyRect.h) ) / st_Y + 0.5;
#else
			x = (DirtyRect.x - 160) * screenSize + rect.w/2;
			y = (DirtyRect.y - 100) * screenSize + rect.y/2;
			w = DirtyRect.w * screenSize;
			h = DirtyRect.h * screenSize;
		x = rect.x;
		y = rect.y;
		w = rect.w;
		h = rect.h;
	SDL_Rect moffaPjopp = DirtyRect;
	moffaPjopp.x *= screenSize;
	moffaPjopp.y *= screenSize;
	moffaPjopp.w *= screenSize;
	moffaPjopp.h *= screenSize;
		x = moffaPjopp.x;
		y = moffaPjopp.y;
		w = moffaPjopp.w;
		h = moffaPjopp.h;
#endif
			x = CLAMP(x,0,rect.w);
			y = CLAMP(y,0,rect.h);
			w = CLAMP(w,0,rect.w-x);
			h = CLAMP(h,0,rect.h-y);
		}
	}
	noDirtyRect = TRUE;
#ifdef _DYN_WINSIZE
	SDL_LockSurface(WND);
	Hermes_ConverterCopy( converter, (ui32*) bitmap, 0, 0, 320, 200, 320, WND->pixels, rect.x, rect.y, rect.w, rect.h, rect.w * info->vfmt->BytesPerPixel );
//	Hermes_ConverterCopy( converter, (ui32*) bitmap, DirtyRect.x, DirtyRect.y, DirtyRect.w, DirtyRect.h, 320, WND->pixels, x, y, w, h, scZi );
	SDL_UnlockSurface(WND);
#else
	SDL_Rect moffaPjopp = DirtyRect;
	moffaPjopp.x *= screenSize;
	moffaPjopp.y *= screenSize;
	moffaPjopp.w *= screenSize;
	moffaPjopp.h *= screenSize;
	SDL_BlitSurface(SCRAP,&moffaPjopp,WND,&moffaPjopp);
#endif
	SDL_UpdateRect(WND,x, y, w, h);
}

bool HasPaletteChanged(i16 *palette, i16 *oldpalette)
{
  bool change=false;
  for (i32 i=0; i<16; i++)
  {
    if (oldpalette[i] != palette[i])
    {
      oldpalette[i]=palette[i];
      change=true;
    };
  };
  return change;
}
#endif

bool HasScreenChanged(i8 *STScreen,    // First byte to test
                      ui32 lineLen,     // dwords
                      ui32 numLine,
                      ui32 lineIncrement,
                      i32 *pOldChecksum)
{
  i32 chk = 0;
  ui32 *CC = (ui32*) STScreen;
  while( numLine-- > 0 ) {
    int l = lineLen;
    while( l-- > 0 ) {
      chk += *(CC++);
    }
    CC = (ui32*) (((char*)CC) + lineIncrement);
  }
  bool huh = (chk != *pOldChecksum);
  *pOldChecksum = chk;
  return huh;
}

static bool HasPaletteChanged(i16 *palette, i16 *oldpalette)
{
  bool change=false;
  for (i32 i=0; i<16; i++)
  {
    if (oldpalette[i] != palette[i])
    {
      oldpalette[i]=palette[i];
      change=true;
    };
  };
  return change;
}

#if 0
void STBlt(i8 *STScreen, // first 16-pixel group
	   ui16 *destination,
           i32 lineLen,  // # 16-pixel groups
           i32 numLine,
           i32 lineIncrement)
{printf("STBlt\n");/*
    __asm__ (
    "movl STScreen, %%esi        \n\t"
    "movl destination, %%edi          \n\t"
"do2line:                    \n\t"
    "movl lineLen, %%eax         \n\t"
    "movw %%ax, counter          \n\t"
"do16bits:                   \n\t"
    "movb 6(%%esi),%%ah            \n\t"
    "movb 4(%%esi),%%al            \n\t"
    "movb 2(%%esi),%%dh            \n\t"
    "movb 0(%%esi),%%dl            \n\t"
    "movw $8,%%cx                 \n\t"
"doTop8bits:                 \n\t"
    "subl %%ebx,%%ebx              \n\t"
    "rclb $1,%%ah                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "rclb $1,%%al                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "rclb $1,%%dh                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "rclb $1,%%dl                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "movw palette16(,%%ebx,2), %%bx \n\t"
    "movw %%bx,(%%edi)             \n\t"
    "addl $2,%%edi                \n\t"
    "decw %%cx                    \n\t"
    "jnz doTop8bits              \n\t"
    "movb 7(%%esi),%%ah            \n\t"
    "movb 5(%%esi),%%al            \n\t"
    "movb 3(%%esi),%%dh            \n\t"
    "movb 1(%%esi),%%dl            \n\t"
    "movw $8,%%cx                 \n\t"
"doBottom8bits:              \n\t"
    "subl %%ebx,%%ebx              \n\t"
    "rclb $1,%%ah                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "rclb $1,%%al                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "rclb $1,%%dh                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "rclb $1,%%dl                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "movw palette16(,%%ebx,2), %%bx \n\t"
//    mov ebx,0000ff00h
    "movw %%bx,(%%edi)             \n\t"
    "addl $2,%%edi                \n\t"
    "decw %%cx                    \n\t"
    "jnz doBottom8bits           \n\t"
    "addl $8,%%esi                \n\t"
    "decw counter					\n\t"
    "jnz do16bits                \n\t"
    "addl lineIncrement, %%esi   \n\t"
    "decw numLine					\n\t"
    "jnz do2Line                 \n\t"

     : // FIXASM: output regs/vars go here, e.g.:  "=m" (memory_var)

     :  // FIXASM: input regs, e.g.:  "c" (count), "S" (src), "D" (dest)

     : "eax","ebx","ecx","edx","edi","esi","cc", "memory" // FIXASM: clobber list, e.g.:  "%eax", "%ecx", "cc"
  );*/
}

void STBlt2(i8 *STScreen, // first 16-pixel group
	    ui16 *destination,
            i32 lineLen,  // # 16-pixel groups
            i32 numLine,
            i32 lineIncrement)
{printf("STBlt2\n");
    /*__asm__ (
    "movl STScreen, %%esi        \n\t"
    "movl destination, %%edi          \n\t"
"do3line:                    \n\t"
    "movl lineLen, %%eax         \n\t"
    "movw %%ax, counter          \n\t"
    "shll $6,%%eax                \n\t" //# 16 pixels/group and 4 bytes per pixel
    "movl %%eax, dstLineLen      \n\t"
"do16bits_2:                   \n\t"
    "movb 6(%%esi),%%ah            \n\t"
    "movb 4(%%esi),%%al            \n\t"
    "movb 2(%%esi),%%dh            \n\t"
    "movb 0(%%esi),%%dl            \n\t"
    "movw $8,%%cx                 \n\t"
    "pushl %%esi                  \n\t"
    "movl dstLineLen, %%esi      \n\t"
"doTop8bits_2:                 \n\t"
    "subl %%ebx,%%ebx              \n\t"
    "rclb $1,%%ah                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "rclb $1,%%al                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "rclb $1,%%dh                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "rclb $1,%%dl                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "movw palette16(,%%ebx,2), %%bx \n\t"
    "movw %%bx,(%%edi)             \n\t"
    "movw %%bx,(%%edi,%%esi)        \n\t"
    "addl $2,%%edi                \n\t"
    "movw %%bx,(%%edi)             \n\t"
    "movw %%bx,0(%%edi,%%esi,1)        \n\t"
    "addl $2,%%edi                \n\t"
    "decw %%cx                    \n\t"
    "jnz doTop8bits_2              \n\t"
    "popl %%esi                   \n\t"
    "movb 7(%%esi),%%ah            \n\t"
    "movb 5(%%esi),%%al            \n\t"
    "movb 3(%%esi),%%dh            \n\t"
    "movb 1(%%esi),%%dl            \n\t"
    "movw $8,%%cx                 \n\t"
    "pushl %%esi                  \n\t"
    "movl dstLineLen, %%esi      \n\t"
"doBottom8bits_2:              \n\t"
    "subl %%ebx,%%ebx              \n\t"
    "rclb $1,%%ah                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "rclb $1,%%al                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "rclb $1,%%dh                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "rclb $1,%%dl                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "movw palette16(,%%ebx,2), %%bx \n\t"
    "movw %%bx,(%%edi)             \n\t"
    "movw %%bx,(%%edi,%%esi)        \n\t"
    "addl $2,%%edi                \n\t"
    "movw %%bx,(%%edi)             \n\t"
    "movw %%bx,(%%edi,%%esi)        \n\t"
    "addl $2,%%edi                \n\t"
    "decw %%cx                    \n\t"
    "jnz doBottom8bits_2           \n\t"
    "popl %%esi                   \n\t"
    "addl $8,%%esi                \n\t"
    "decw counter					\n\t"
    "jnz do16bits_2                \n\t"
    "addl lineIncrement, %%esi   \n\t"
    "addl dstLineLen, %%edi      \n\t"
    "decw numLine					\n\t"
    "jnz do3Line                 \n\t"

     : // FIXASM: output regs/vars go here, e.g.:  "=m" (memory_var)

     : // FIXASM: input regs, e.g.:  "c" (count), "S" (src), "D" (dest)

     : "eax","ebx","ecx","edx","edi","esi","cc", "memory" // FIXASM: clobber list, e.g.:  "%%eax", "%%ecx", "cc"
  );*/
}

void STBlt3(i8 *STScreen, // first 16-pixel group
	    ui16 *destination,
            i32 lineLen,  // # 16-pixel groups
            i32 numLine,
            i32 lineIncrement)
{printf("STBlt3\n");
  /*  __asm__ (
    "movl STScreen, %%esi        \n\t"
    "movl destination, %%edi          \n\t"
"do4line:                    \n\t"
    "movl lineLen, %%eax         \n\t"
    "movw %%ax, counter          \n\t"
    "imull $16*2*3,%%eax          \n\t" //# 16 pixels per group * 2 bytes per pixel * 3 pixels per pixel
    "movl %%eax, dstLineLen      \n\t"
"do16bits_3:                   \n\t"
    "movb 6(%%esi),%%ah            \n\t"
    "movb 4(%%esi),%%al            \n\t"
    "movb 2(%%esi),%%dh            \n\t"
    "movb 0(%%esi),%%dl            \n\t"
    "movw $8,%%cx                 \n\t"
    "pushl %%esi                  \n\t"
    "movl dstLineLen, %%esi      \n\t"
"doTop8bits_3:                 \n\t"
    "subl %%ebx,%%ebx              \n\t"
    "rclb $1,%%ah                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "rclb $1,%%al                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "rclb $1,%%dh                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "rclb $1,%%dl                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "movw palette16(,%%ebx,2), %%bx \n\t"
    "movw %%bx,(%%edi)             \n\t"
    "movw %%bx,(%%edi,%%esi)        \n\t"
    "movw %%bx,(%%edi,%%esi,2)      \n\t"
    "addl $2,%%edi                \n\t"
    "movw %%bx,(%%edi)             \n\t"
    "movw %%bx,(%%edi,%%esi)        \n\t"
    "movw %%bx,(%%edi,%%esi,2)      \n\t"
    "addl $2,%%edi                \n\t"
    "movw %%bx,(%%edi)             \n\t"
    "movw %%bx,(%%edi,%%esi)        \n\t"
    "movw %%bx,(%%edi,%%esi,2)      \n\t"
    "addl $2,%%edi                \n\t"
    "decw %%cx                    \n\t"
    "jnz doTop8bits_3              \n\t"
    "popl %%esi                   \n\t"
    "movb 7(%%esi),%%ah            \n\t"
    "movb 5(%%esi),%%al            \n\t"
    "movb 3(%%esi),%%dh            \n\t"
    "movb 1(%%esi),%%dl            \n\t"
    "movw $8,%%cx                 \n\t"
    "pushl %%esi                  \n\t"
    "movl dstLineLen, %%esi      \n\t"
"doBottom8bits_3:              \n\t"
    "subl %%ebx,%%ebx              \n\t"
    "rclb $1,%%ah                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "rclb $1,%%al                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "rclb $1,%%dh                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "rclb $1,%%dl                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "movw palette16(,%%ebx,2), %%bx \n\t"
    "movw %%bx,(%%edi)             \n\t"
    "movw %%bx,(%%edi,%%esi)        \n\t"
    "movw %%bx,(%%edi,%%esi,2)      \n\t"
    "addl $2,%%edi                \n\t"
    "movw %%bx,(%%edi)             \n\t"
    "movw %%bx,(%%edi,%%esi)        \n\t"
    "movw %%bx,(%%edi,%%esi,2)      \n\t"
    "addl $2,%%edi                \n\t"
    "movw %%bx,(%%edi)             \n\t"
    "movw %%bx,(%%edi,%%esi)        \n\t"
    "movw %%bx,(%%edi,%%esi,2)      \n\t"
    "addl $2,%%edi                \n\t"
    "decw %%cx                    \n\t"
    "jnz doBottom8bits_3           \n\t"
    "popl %%esi                   \n\t"
    "addl $8,%%esi                \n\t"
    "decw counter					\n\t"
    "jnz do16bits_3                \n\t"
    "addl lineIncrement, %%esi   \n\t"
    "addl dstLineLen, %%edi      \n\t"
    "addl dstLineLen, %%edi      \n\t"
    "decw numLine					\n\t"
    "jnz do4Line                 \n\t"

     : // FIXASM: output regs/vars go here, e.g.:  "=m" (memory_var)

     : // FIXASM: input regs, e.g.:  "c" (count), "S" (src), "D" (dest)

     : "eax","ebx","ecx","edx","edi","esi","cc", "memory" // FIXASM: clobber list, e.g.:  "%%eax", "%%ecx", "cc"
  );*/
}

void STBlt4(i8 *STScreen, // first 16-pixel group
	    ui16 *destination,
            i32 lineLen,  // # 16-pixel groups
            i32 numLine,
            i32 lineIncrement)
{printf("STBlt4\n");
   /* __asm__ (
    "movl STScreen, %%esi        \n\t"
    "movl destination, %%edi          \n\t"
"do5line:                    \n\t"
    "movl lineLen, %%eax         \n\t"
    "movw %%ax, counter          \n\t"
    "imull $16*2*4,%%eax          \n\t" //# 16 pixels per group * 2 bytes per pixel * 4 pixels per pixel
    "movl %%eax, dstLineLen      \n\t"
"do16bits_4:                   \n\t"
    "movb 6(%%esi),%%ah            \n\t"
    "movb 4(%%esi),%%al            \n\t"
    "movb 2(%%esi),%%dh            \n\t"
    "movb 0(%%esi),%%dl            \n\t"
    "movw $8,%%cx                 \n\t"
    "pushl %%esi                  \n\t"
    "movl dstLineLen, %%esi      \n\t"
"doTop8bits_4:                 \n\t"
    "subl %%ebx,%%ebx              \n\t"
    "rclb $1,%%ah                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "rclb $1,%%al                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "rclb $1,%%dh                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "rclb $1,%%dl                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "movw palette16(,%%ebx,2), %%bx \n\t"
    "movw %%bx,(%%edi)             \n\t"
    "movw %%bx,(%%edi,%%esi)        \n\t"
    "movw %%bx,(%%edi,%%esi,2)      \n\t"
    "addl %%esi,%%edi              \n\t"
    "movw %%bx,(%%edi,%%esi,2)      \n\t"
    "subl %%esi,%%edi              \n\t"
    "addl $2,%%edi                \n\t"
    "movw %%bx,(%%edi)             \n\t"
    "movw %%bx,(%%edi,%%esi)        \n\t"
    "movw %%bx,(%%edi,%%esi,2)      \n\t"
    "addl %%esi,%%edi              \n\t"
    "movw %%bx,(%%edi,%%esi,2)      \n\t"
    "subl %%esi,%%edi              \n\t"
    "addl $2,%%edi                \n\t"
    "movw %%bx,(%%edi)             \n\t"
    "movw %%bx,(%%edi,%%esi)        \n\t"
    "movw %%bx,(%%edi,%%esi,2)      \n\t"
    "addl %%esi,%%edi              \n\t"
    "movw %%bx,(%%edi,%%esi,2)      \n\t"
    "subl %%esi,%%edi              \n\t"
    "addl $2,%%edi                \n\t"
    "movw %%bx,(%%edi)             \n\t"
    "movw %%bx,(%%edi,%%esi)        \n\t"
    "movw %%bx,(%%edi,%%esi,2)      \n\t"
    "addl %%esi,%%edi              \n\t"
    "movw %%bx,(%%edi,%%esi,2)      \n\t"
    "subl %%esi,%%edi              \n\t"
    "addl $2,%%edi                \n\t"
    "decw %%cx                    \n\t"
    "jnz doTop8bits_4              \n\t"
    "popl %%esi                   \n\t"
    "movb 7(%%esi),%%ah            \n\t"
    "movb 5(%%esi),%%al            \n\t"
    "movb 3(%%esi),%%dh            \n\t"
    "movb 1(%%esi),%%dl            \n\t"
    "movw $8,%%cx                 \n\t"
    "pushl %%esi                  \n\t"
    "movl dstLineLen, %%esi      \n\t"
"doBottom8bits_4:              \n\t"
    "subl %%ebx,%%ebx              \n\t"
    "rclb $1,%%ah                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "rclb $1,%%al                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "rclb $1,%%dh                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "rclb $1,%%dl                 \n\t"
    "rclb $1,%%bl                 \n\t"
    "movw palette16(,%%ebx,2), %%bx \n\t"
    "movw %%bx,(%%edi)             \n\t"
    "movw %%bx,(%%edi,%%esi)        \n\t"
    "movw %%bx,(%%edi,%%esi,2)      \n\t"
    "addl %%esi,%%edi              \n\t"
    "movw %%bx,(%%edi,%%esi,2)      \n\t"
    "subl %%esi,%%edi              \n\t"
    "addl $2,%%edi                \n\t"
    "movw %%bx,(%%edi)             \n\t"
    "movw %%bx,(%%edi,%%esi)        \n\t"
    "movw %%bx,(%%edi,%%esi,2)      \n\t"
    "addl %%esi,%%edi              \n\t"
    "movw %%bx,(%%edi,%%esi,2)      \n\t"
    "subl %%esi,%%edi              \n\t"
    "addl $2,%%edi                \n\t"
    "movw %%bx,(%%edi)             \n\t"
    "movw %%bx,(%%edi,%%esi)        \n\t"
    "movw %%bx,(%%edi,%%esi,2)      \n\t"
    "addl %%esi,%%edi              \n\t"
    "movw %%bx,(%%edi,%%esi,2)      \n\t"
    "subl %%esi,%%edi              \n\t"
    "addl $2,%%edi                \n\t"
    "movw %%bx,(%%edi)             \n\t"
    "movw %%bx,(%%edi,%%esi)        \n\t"
    "movw %%bx,(%%edi,%%esi,2)      \n\t"
    "addl %%esi,%%edi              \n\t"
    "movw %%bx,(%%edi,%%esi,2)      \n\t"
    "subl %%esi,%%edi              \n\t"
    "addl $2,%%edi                \n\t"
    "decw %%cx                    \n\t"
    "jnz doBottom8bits_4           \n\t"
    "popl %%esi                   \n\t"
    "addl $8,%%esi                \n\t"
    "decw counter					\n\t"
    "jnz do16bits_4                \n\t"
    "addl lineIncrement, %%esi   \n\t"
    "addl dstLineLen, %%edi      \n\t"
    "addl dstLineLen, %%edi      \n\t"
    "addl dstLineLen, %%edi      \n\t"
    "decw numLine					\n\t"
    "jnz do5Line                 \n\t"

     : // FIXASM: output regs/vars go here, e.g.:  "=m" (memory_var)

     : // FIXASM: input regs, e.g.:  "c" (count), "S" (src), "D" (dest)

     : "eax","ebx","ecx","edx","edi","esi","cc", "memory" // FIXASM: clobber list, e.g.:  "%%eax", "%%ecx", "cc"
  );*/
}



static void createPalette32( i32 * palette32, i16 *palette)
{ // Create 32-bit color palette from the ST 9-bit palette
  for (i32 i=0; i<16; i++)
  {
    ASSERT(palette[i]<=0x777, "no text");
 //   palette32[i].r = (((palette[i]>>8) & 7)*0xff/0x7); //<<16;
 //   palette32[i].g = (((palette[i]>>4) & 7)*0xff/0x7); //<< 8;
 //   palette32[i].b = (((palette[i]>>0) & 7)*0xff/0x7); //<< 0;
   palette32[i] = (
		(((palette[i]>>8) & 7)*(0xff/0x7))<< PALETTE_RED_BITS // Red
	  ) | (
		(((palette[i]>>4) & 7)*0xff/0x7)<< PALETTE_GREEN_BITS  // Green
	  ) | (
		(((palette[i]>>0) & 7)*0xff/0x7)<< PALETTE_BLUE_BITS  // Blue
	  );
  }
}
#endif

#ifndef OLD_BLITTER
/**
 * Unpack bits from ST planes into bytes
 * @src   Ptr to planar words (4 words containing 16 pixels)
 * @param shift Number of bits to ignore at the beginning
 */
static void Unpack(const ui16 *src, unsigned char *dst, i32 shift, i32 count)
{
  /* Read the four ST planes. */
  ui16 _one = *(src++); ui32 four = GUINT16_FROM_BE(_one);
  ui16 _two = *(src++); ui32 three = GUINT16_FROM_BE(_two);
  ui16 _three=*(src++); ui32 two = GUINT16_FROM_BE(_three);
  ui16 _four= *(src++); ui32 one = GUINT16_FROM_BE(_four);
  one<<=shift; one |= one>>16;
  two<<=shift; two |= two>>16;
  three<<=shift; three|=three>>16;
  four<<=shift;  four|=four>>16;
  while (count--) {
    *dst = (one & 0x8000 ? 0x08 : 0)
        | (two & 0x8000 ? 0x04 : 0)
        | (three & 0x8000 ? 0x02 : 0)
        | (four & 0x8000 ? 0x01 : 0);
    one<<=1; one |= one>>16;
    two<<=1; two |= two>>16;
    three<<=1; three|=three>>16;
    four<<=1; four|=four>>16;
    dst++;
  }
}

static void BLT1_16(unsigned char *src, ui16 *dst, ui32 stride, i32 num, ui32 *palette, ui8 *overlay)
{
  while (num--) {
    *(ui16*)dst = palette[(overlay[0] << 4) | *src];
    dst+=1;
    src++;
    overlay++;
  }
}

static void BLT2_16(unsigned char *src, ui16 *dst, ui32 stride, i32 num, ui32 *palette, ui8 *overlay)
{
  while (num--) {
    ui32 col = palette[((ui16)overlay[0] << 4) | *src];
    ((ui32*)dst)[0] = col;
    ((ui32*)dst)[stride/4] = col;
    dst+=2;
    src++;
    overlay++;
  }
}

static void BLT3_16(unsigned char *src, ui16 *dst, ui32 stride, i32 num, ui32 *palette, ui8 *overlay)
{
  while (num--) {
    ui32 col = palette[((ui16)overlay[0] << 4) | *src];
    ((ui32*)dst)[0] = ((ui32*)dst)[stride/4] = col;
    ((ui16*)dst)[2] = ((ui16*)dst)[stride/2+2] = col;
    dst+=3;
    src++;
    overlay++;
  }
}

static void BLT4_16(unsigned char *src, ui16 *dst, ui32 stride, i32 num, ui32 *palette, ui8 *overlay)
{
  while (num--) {
    ui32 col = palette[((ui16)overlay[0] << 4) | *src];
    ((ui32*)dst)[0]          = ((ui32*)dst)[1] = col;
    ((ui32*)dst)[stride/4]   = ((ui32*)dst)[stride/4+1] = col;
    ((ui32*)dst)[stride*2/4] = ((ui32*)dst)[stride*2/4+1] = col;
    ((ui32*)dst)[stride*3/4] = ((ui32*)dst)[stride*3/4+1] = col;
    dst+=4;
    src++;
    overlay++;
  }
}

static void BLT1_32(unsigned char *src, ui16 *dst, ui32 stride, i32 num, ui32 *palette, ui8 *overlay)
{
  while (num--) {
    *(ui32*)dst = palette[(overlay[0] << 4) | *src];
    dst+=2;
    src++;
    overlay++;
  }
}

static void BLT2_32(unsigned char *src, ui16 *dst, ui32 stride, i32 num, ui32 *palette, ui8 *overlay)
{
  while (num--) {
    ui32 srccol = palette[((ui16)overlay[0] << 4) | *src];
    ((ui32*)dst)[0] = ((ui32*)dst)[stride/4] = srccol;
    ((ui32*)dst)[1] = ((ui32*)dst)[stride/4+1] = srccol;
    dst+=4;
    src++;
    overlay++;
  }
}

static void BLT3_32(unsigned char *src, ui16 *dst, ui32 stride, i32 num, ui32 *palette, ui8 *overlay)
{
  while (num--) {
    ui32 srccol = palette[((ui16)overlay[0] << 4) | *src];
    ((ui32*)dst)[0] = ((ui32*)dst)[stride/4]   = ((ui32*)dst)[stride*2/4]   = srccol;
    ((ui32*)dst)[1] = ((ui32*)dst)[stride/4+1] = ((ui32*)dst)[stride*2/4+1] = srccol;
    ((ui32*)dst)[2] = ((ui32*)dst)[stride/4+2] = ((ui32*)dst)[stride*2/4+2] = srccol;
    dst+=6;
    src++;
    overlay++;
  }
}

static void BLT4_32(unsigned char *src, ui16 *dst, ui32 stride, i32 num, ui32 *palette, ui8 *overlay)
{
  while (num--) {
    ui32 srccol = palette[((ui16)overlay[0] << 4) | *src];
    ((ui32*)dst)[0] = ((ui32*)dst)[stride/4]   = ((ui32*)dst)[stride*2/4]   = ((ui32*)dst)[stride*3/4]   = srccol;
    ((ui32*)dst)[1] = ((ui32*)dst)[stride/4+1] = ((ui32*)dst)[stride*2/4+1] = ((ui32*)dst)[stride*3/4+1] = srccol;
    ((ui32*)dst)[2] = ((ui32*)dst)[stride/4+2] = ((ui32*)dst)[stride*2/4+2] = ((ui32*)dst)[stride*3/4+2] = srccol;
    ((ui32*)dst)[3] = ((ui32*)dst)[stride/4+3] = ((ui32*)dst)[stride*2/4+3] = ((ui32*)dst)[stride*3/4+3] = srccol;
    dst+=8;
    src++;
    overlay++;
  }
}

#else // !OLD_BLITTER
/**
 * Convert ST palette to RGB colors. Also checks for changes againt oldPalette and returns flag.
 */
bool convertPalette(tPaletteColor *dest, const SDL_PixelFormat *format, i16 *palette, i16 *oldpalette)
{
  bool change=false;
  for (i32 i=0; i<16; i++)
  {
    if (oldpalette[i] != palette[i])
    {
      oldpalette[i]=palette[i];
      dest[i] = SDL_MapRGB(format,
          ((palette[i]>>8) & 7)*(0xff/0x7), // Red
          ((palette[i]>>4) & 7)*(0xff/0x7), // Green
          ((palette[i]>>0) & 7)*(0xff/0x7)); // Blue
      // for 16 bits per pixel, duplicate the lower word in the higher word
      if (format->BytesPerPixel==2)
        dest[i] |= dest[i] << 16;
      change=true;
    };
  };
  return change;
}

static inline void writeColors2_16(ui16 *&dest, const ui32 &pitch, ui32 color, const tPaletteColor *palette)
{
  color &= 0xF;
  *(ui32*)dest = palette[color];
  ((ui32*)dest)[pitch / 4] = palette[color];
  dest+=2;
}

static inline void writeColors2_32(ui16 *&dest, const ui32 &pitch, ui32 color, const tPaletteColor *palette)
{
  color &= 0xF;
  *(ui32*)dest = palette[color];
  ((ui32*)dest)[1] = palette[color];
  ((ui32*)dest)[pitch / 4] = palette[color];
  ((ui32*)dest)[pitch / 4 + 1] = palette[color];
  dest+=4;
}
#endif // OLD_BLITTER

static void UpdateScreenArea(
                      i8  *STScreen,
		      SDL_Surface *destSurface,
                      i32  x0,
                      i32  y0,
                      i32  width,
                      i32  height,
                      i32  destX,
                      i32  destY,
                      tPaletteColor *palette,
                      bool paletteChanged,
                      i32 *pOldChecksum,
                      i32 size,
                      bool useOverlay)
{
  // clip against surface borders to avoid crashes
  if (destX>=destSurface->w || destY>=destSurface->h)
    return;
  if (destX+width*size>=destSurface->w)
    width = (destSurface->w - destX) / size;
  if (destY+height*size>=destSurface->h)
    height = (destSurface->h - destY) / size;
  width &= 0xFFF0; // round down to multiples of 16

  const i32 LineStart = (x0/16) * 8;
  const i32 LineEnd   = ((x0+width+15)/16) * 8;
  ui16 *dest = ((ui16*)destSurface->pixels) + destY*destSurface->pitch/sizeof(ui16) + destX*destSurface->format->BytesPerPixel/sizeof(ui16);
#ifdef OLD_BLITTER
  ui32 destIncrement = (destSurface->pitch * size
      - width * destSurface->format->BytesPerPixel * size) / sizeof(ui16);
  ui16 *scr = (ui16*) (STScreen + 160*y0 + LineStart);
  const int increment = 160-(LineEnd-LineStart);
  if (!paletteChanged)
  {
    if (!HasScreenChanged(STScreen+160*y0+LineStart,
        (LineEnd-LineStart) / 4,
        height,
        160-(LineEnd-LineStart),
        pOldChecksum))
      return;
  };
  //printf("UpdateScreenArea(%d,%d)x(%d,%d)->(%d,%d)\n", x0, y0, width, height, destX, destY);
  //printf("dest surface size=%dx%d bpp=%d\n", destSurface->w, destSurface->h, destSurface->format->BitsPerPixel);
  mkDirty(destX,destY,width*size,height*size);

  /* This is not the most efficient solution, but it is portable. :o) */
  for (i32 h = height; h>0; h--) {
      int lineCnt = (LineEnd-LineStart)/8;
      while( lineCnt-- > 0 ) {
        /* Read the four ST planes. */
        ui16 _one = *(scr++); ui16 four = GUINT16_FROM_BE(_one);
        ui16 _two = *(scr++); ui16 three = GUINT16_FROM_BE(_two);
        ui16 _three=*(scr++); ui16 two = GUINT16_FROM_BE(_three);
        ui16 _four= *(scr++); ui16 one = GUINT16_FROM_BE(_four);
        /*
         * one  = [p0b3 p1b3 p2b3 p3b3 p4b3 p5b3 p6b3 ... p15b3]
         * two  = [p0b2 p1b2 ...                          p15b2]
         * three= [p0b1 p1b1 ...                          p15b1]
         * four = [p0b0 p1b2 ...                          p15b0]
         */
        /* Get pixel# 0, 4, 8, 12 */
        ui16 c1 = ((one>>0) & 0x8888) | ((two>>1) & 0x4444) | ((three>>2) & 0x2222) | ((four>>3) & 0x1111);
        /* Get pixel# 1, 5, 9, 13 */
        ui16 c2 = ((one<<1) & 0x8888) | ((two>>0) & 0x4444) | ((three>>1) & 0x2222) | ((four>>2) & 0x1111);
        /* Get pixel# 2, 6, 10, 14 */
        ui16 c3 = ((one<<2) & 0x8888) | ((two<<1) & 0x4444) | ((three>>0) & 0x2222) | ((four>>1) & 0x1111);
        /* Get pixel# 3, 7, 11, 15 */
        ui16 c4 = ((one<<3) & 0x8888) | ((two<<2) & 0x4444) | ((three<<1) & 0x2222) | ((four>>0) & 0x1111);

        switch (destSurface->format->BytesPerPixel) {
        case 2:
          // pixels 0-3
          writeColors2_16(dest, destSurface->pitch, c1>>12, palette);
          writeColors2_16(dest, destSurface->pitch, c2>>12, palette);
          writeColors2_16(dest, destSurface->pitch, c3>>12, palette);
          writeColors2_16(dest, destSurface->pitch, c4>>12, palette);
          // pixels 4-7
          writeColors2_16(dest, destSurface->pitch, c1>> 8, palette);
          writeColors2_16(dest, destSurface->pitch, c2>> 8, palette);
          writeColors2_16(dest, destSurface->pitch, c3>> 8, palette);
          writeColors2_16(dest, destSurface->pitch, c4>> 8, palette);
          // pixels 8-11
          writeColors2_16(dest, destSurface->pitch, c1>> 4, palette);
          writeColors2_16(dest, destSurface->pitch, c2>> 4, palette);
          writeColors2_16(dest, destSurface->pitch, c3>> 4, palette);
          writeColors2_16(dest, destSurface->pitch, c4>> 4, palette);
          // pixels 12-15
          writeColors2_16(dest, destSurface->pitch, c1>> 0, palette);
          writeColors2_16(dest, destSurface->pitch, c2>> 0, palette);
          writeColors2_16(dest, destSurface->pitch, c3>> 0, palette);
          writeColors2_16(dest, destSurface->pitch, c4>> 0, palette);
          break;
        case 4:
          // pixels 0-3
          writeColors2_32(dest, destSurface->pitch, c1>>12, palette);
          writeColors2_32(dest, destSurface->pitch, c2>>12, palette);
          writeColors2_32(dest, destSurface->pitch, c3>>12, palette);
          writeColors2_32(dest, destSurface->pitch, c4>>12, palette);
          // pixels 4-7
          writeColors2_32(dest, destSurface->pitch, c1>> 8, palette);
          writeColors2_32(dest, destSurface->pitch, c2>> 8, palette);
          writeColors2_32(dest, destSurface->pitch, c3>> 8, palette);
          writeColors2_32(dest, destSurface->pitch, c4>> 8, palette);
          // pixels 8-11
          writeColors2_32(dest, destSurface->pitch, c1>> 4, palette);
          writeColors2_32(dest, destSurface->pitch, c2>> 4, palette);
          writeColors2_32(dest, destSurface->pitch, c3>> 4, palette);
          writeColors2_32(dest, destSurface->pitch, c4>> 4, palette);
          // pixels 12-15
          writeColors2_32(dest, destSurface->pitch, c1>> 0, palette);
          writeColors2_32(dest, destSurface->pitch, c2>> 0, palette);
          writeColors2_32(dest, destSurface->pitch, c3>> 0, palette);
          writeColors2_32(dest, destSurface->pitch, c4>> 0, palette);
          break;
        }
      }
      scr = (ui16*) (  ((ui8*)scr) + increment);
      dest += destIncrement;
  }
  STBLTCount++;
#else // OLD_BLITTER
  bool overlayChanged = false;
  i32 firstNibble[7];
  i32 firstOverlay[7];
  i32 segWidth[7];
  unsigned char nibbles[320];
  unsigned char *pNibbles = nibbles;
  i32 line, segment, xgj, xoj, ygj, currentGraphicLine, lastGraphicLine;
  i32 numPixel, skipPixel, n;
  char *pFirstGroup;
  void (*blitFunc)(unsigned char *src, ui16 *dst, ui32 stride, i32 num, ui32 *palette, ui8 *overlay) = NULL;
  //updateScreenAreaEnterCount++;
  overlayChanged = useOverlay && currentOverlay.m_change;
  currentOverlay.m_change = false;
  if (!paletteChanged && !overlayChanged && !jitterChanged)
  {
    if (!HasScreenChanged(STScreen+160*y0+LineStart,
                          (LineEnd-LineStart) / 4,
                          height,
                          160-(LineEnd-LineStart),
                          pOldChecksum))
    {
      //updateScreenAreaLeaveCount++;
      return;
    };
  };
  mkDirty(destX,destY,width*size,height*size);

  //createPalette16(palette);
  //if (pOverlayData != NULL)
  //{
  //  pOverlayData->CreateOverlayTable(palette16);
  //  pPalette = pOverlayData->m_table;
  //}
  //else
  //{
  //  pPalette = palette16;
  //};
  jitterChanged = false;
  currentOverlay.Allocate();
  currentOverlay.CreateOverlayTable(palette, useOverlay);
  //pPalette = pOverlayData->m_table;

  STBLTCount++;
  if (useOverlay)
  {
    xgj = xGraphicJitter;
    xoj = xOverlayJitter;
    ygj = yGraphicJitter;
  }
  else
  {
    xgj = 0;
    xoj = 0;
    ygj = 0;
  };
  if (ygj >= 0)
  {
    currentGraphicLine = -ygj;
    lastGraphicLine = height - ygj - 1;
  }
  else
  {
    currentGraphicLine = -ygj;
    lastGraphicLine = height;
  };

/* There are 13 cases
 *    xGraphicJitter  xOverlayJitter
 *         -10            -15    GO-G-B
 *         -10            -10    GO-B
 *         -10             -5    GO-O-B
 *         -10              0    GO-O
 *         -10             10    G-GO-O
 *           0            -10    GO-G
 *           0              0    GO
 *           0             10    G-GO
 *          10            -10    O-GO-G
 *          10              5    B-O-GO
 *          10              0    O-GO
 *          10             10    B-GO
 *          10             15    B-G-GO
 *
 *    Altogether we have seven segments in each line
 *        n0 B
 *        n1 G
 *        n2 O
 *        n3 GO
 *        n4 G
 *        n5 O
 *        n6 B
 *
 *
 * Now we will determine all the parameters for displaying a
 * line for each of 13 possible cases.
 */
  if (xgj < 0)
  {
    if (xoj < 0)
    {
      NotImplemented(0x777107);
    }
    else if (xoj == 0)
    {
      segWidth[0] = 0;
      segWidth[1] = 0;
      segWidth[2] = 0;
      firstNibble[3] = -xgj;
      firstOverlay[3] = 0;
      segWidth[3] = width + xgj;
      segWidth[4] = 0;
      segWidth[5] = 0;
      segWidth[6] = -xgj;
      firstNibble[6] = -1;
      firstOverlay[6] = width + xgj;
    }
    else
    {
      NotImplemented(0x777109);
    };
  }
  else if (xgj == 0)
  {
    if (xoj < 0)
    {
      NotImplemented(0x777101);
    }
    else if (xoj == 0)
    {
      segWidth[0] = 0;
      segWidth[1] = 0;
      segWidth[2] = xgj;
      firstNibble[2] = -1;
      firstOverlay[2] = 0;
      firstNibble[3] = 0;
      firstOverlay[3] = firstOverlay[2]+xgj;
      segWidth[3] = width - xgj;
      segWidth[4] = 0;
      segWidth[5] = 0;
      segWidth[6] = 0;
    }
    else
    {
      NotImplemented(0x777104);
    };
  }
  else
  {
    if (xoj == 0)
    {
      segWidth[0] = 0;
      segWidth[1] = 0;
      segWidth[2] = xgj;
      firstOverlay[2] = 0;
      firstNibble[2] = -1;
      firstNibble[3] = 0;
      firstOverlay[3] = xgj;
      segWidth[3] = width - xgj;
      segWidth[4] = 0;
      segWidth[5] = 0;
      segWidth[6] = 0;
    }
    else if (xoj < 0)
    {
      NotImplemented(0x777111);
    }
    else
    {
      NotImplemented(0x777112);
    };
  };

  // pick the correct blitting function
  if (destSurface->format->BytesPerPixel==2) {
    switch (size) {
    case 1: blitFunc = BLT1_16; break;
    case 2: blitFunc = BLT2_16; break;
    case 3: blitFunc = BLT3_16; break;
    case 4: blitFunc = BLT4_16; break;
    }
  }
  else if (destSurface->format->BytesPerPixel==4) {
    switch (size) {
    case 1: blitFunc = BLT1_32; break;
    case 2: blitFunc = BLT2_32; break;
    case 3: blitFunc = BLT3_32; break;
    case 4: blitFunc = BLT4_32; break;
    }
  }
  if (blitFunc==NULL) {
    NotImplemented();
    return;
  }

  // blit the pixels
  for (line=0; line<height; line++, currentGraphicLine++)
  {
    i32 currentPixel;
    if ((currentGraphicLine < 0) || (currentGraphicLine > lastGraphicLine))
    {
      memset (nibbles,0,width);
    }
    else
    {
      pFirstGroup = STScreen + 160*(y0+currentGraphicLine) + LineStart;
      numPixel = width;
      skipPixel = x0 & 15;
      pNibbles = nibbles;
      if (skipPixel != 0)
      {
        n = 16 - skipPixel;
        if (n > numPixel) n = numPixel;
        Unpack((const ui16*)pFirstGroup, pNibbles, skipPixel, n);
        pNibbles += n;
        numPixel -= n;
        pFirstGroup += 8;
      };
      while (numPixel > 0)
      {
        n = 16;
        if (n > numPixel) n = numPixel;
        Unpack((const ui16*)pFirstGroup, pNibbles, 0, n);
        pNibbles += n;
        numPixel -= n;
        pFirstGroup += 8;
      };
    };

    currentPixel = 0;

    for (segment=0; segment<7; segment++)
    {
      ui8 *pOverlay;
      if (segWidth[segment] == 0) continue;
      pNibbles = (firstNibble[segment] < 0) ? black : nibbles + firstNibble[segment];
      pOverlay =   (useOverlay && overlayActive)
                 ? currentOverlay.m_overlay+224*(135-line) + firstOverlay[segment]
                 : black;
      blitFunc(pNibbles,
              dest + currentPixel,
              destSurface->pitch,
              segWidth[segment],
              currentOverlay.m_table,
              pOverlay);
      currentPixel += segWidth[segment] * destSurface->format->BytesPerPixel * size / sizeof(ui16);
    };
    dest+=destSurface->pitch * size / sizeof(ui16);
  };
#endif // OLD_BLITTER
};




void display (void){
  bool pc1, pc2;
  static i32 oldChecksumA;
  static i32 oldChecksumB;
  static i32 oldChecksumC;
  static i32 oldChecksumD;
  static int numDisplay = 0;

#ifdef _DYN_WINSIZE
  SDL_Surface *destSurface = SCRAP;
  i32 zoomFactor = 1; // the graphics will be enlarged later on by the Hermes scaling functions.
#else
  SDL_Surface *destSurface = WND;
  i32 zoomFactor = screenSize;
#endif

  numDisplay++;
  if ((VBLMultiplier!=1) && ((d.Time&0xf)!=0) && (VBLMultiplier!=99)) return;
#ifdef OLD_BLITTER
  if (d.DynamicPaletteSwitching)
  {
    pc1 = convertPalette(palette1,destSurface->format,d.Palette11978.color, oldPalette1);
    pc2 = convertPalette(palette2,destSurface->format,d.Palette11946.color, oldPalette2);
    memcpy(globalPalette,&d.Palette11978,32);
  }
  else
  {
    pc1 = convertPalette(palette1, destSurface->format, globalPalette, oldPalette1);
    pc2 = convertPalette(palette2, destSurface->format, globalPalette, oldPalette2);
  };
  pc1 = pc1 || ForcedScreenDraw;
  pc2 = pc2 || ForcedScreenDraw;
  ForcedScreenDraw = false;
#else // OLD_BLITTER
  if (d.DynamicPaletteSwitching)
  {
    memcpy(palette1,&d.Palette11978, 32);
    memcpy(palette2,&d.Palette11946, 32);
    memcpy(globalPalette,&d.Palette11978,32);
  }
  else
  {
    memcpy(palette1,globalPalette, 32);
    memcpy(palette2,globalPalette, 32);
  };
  pc1 = HasPaletteChanged(palette1, oldPalette1);
  pc2 = HasPaletteChanged(palette2, oldPalette2);
  pc1 = pc1 || ForcedScreenDraw;
  pc2 = pc2 || ForcedScreenDraw;
  ForcedScreenDraw = false;
  currentOverlay.m_colorFormat = (destSurface->format->BytesPerPixel==4)
      ? OVERLAYDATA::CF_RGB888 : OVERLAYDATA::CF_RGB565;
#endif // OLD_BLITTER
	SDL_LockSurface(destSurface);
	if (!fullscreenActive)
	{
	  UpdateScreenArea(         //Viewport
	      physbase(),//STScreen,
	      WND,
	      0,
	      0x21,
	      0xe0,
	      0xa9-0x21,
        0*zoomFactor,
        0x21*zoomFactor,
	      palette2,
	      pc2,
	      &oldChecksumA, zoomFactor,
	      videoMode==VM_ADVENTURE);
	  UpdateScreenArea(   //Text scrolling area
	      physbase(),//STScreen,
	      WND,
	      0,
	      0xa9,
	      320,
	      0xc8-0xa9,
        0*zoomFactor,
        0xa9*zoomFactor,
	      palette1,
	      pc1,
	      &oldChecksumB, zoomFactor,
	      false);
	  UpdateScreenArea(             //portrait area
	      physbase(),//STScreen,
	      WND,
	      0,
	      0,
	      320,
	      0x21,
        0*zoomFactor,
        0*zoomFactor,
	      palette1,
	      pc1,
	      &oldChecksumC, zoomFactor,
	      false);
	  UpdateScreenArea(              //spells,weapons,moves
	      physbase(),//STScreen,
	      WND,
	      0xe0,
	      0x21,
	      0x140-0xe0,
	      0xa9-0x21,
        0xe0*zoomFactor,
        0x21*zoomFactor,
        palette2,
	      pc2,
	      &oldChecksumD, zoomFactor,
	      false);
	}
	else
	{
	  if (videoSegSize[0] != 0)
	  {
	    UpdateScreenArea(         //Viewport
	        physbase(),//STScreen,
	        WND,
	        videoSegSrcX[0],
	        videoSegSrcY[0],
	        videoSegWidth[0],
	        videoSegHeight[0],
	        videoSegX[0],
	        videoSegY[0],
	        palette2,
	        pc2,
	        &oldChecksumA,
	        videoSegSize[0],
	        videoMode==VM_ADVENTURE);
	  };
	  if (videoSegSize[1] != 0)
	  {
	    UpdateScreenArea(             //portrait area
	        physbase(),//STScreen,
	        WND,
	        videoSegSrcX[1],
	        videoSegSrcY[1],
	        videoSegWidth[1],
	        videoSegHeight[1],
	        videoSegX[1],
	        videoSegY[1],
	        palette1,
	        pc1,
	        &oldChecksumC,
	        videoSegSize[1],
	        false);
	  };
	  if (videoSegSize[2] != 0)
	  {
	    UpdateScreenArea(              //spells,weapons,moves
	        physbase(),//STScreen,
	        WND,
	        videoSegSrcX[2],
	        videoSegSrcY[2],
	        videoSegWidth[2],
	        videoSegHeight[2],
	        videoSegX[2],
	        videoSegY[2],
	        palette2,
	        pc2,
	        &oldChecksumD,
	        videoSegSize[2],
	        false);
	  };
	  if (videoSegSize[3] != 0)
	  {
	    UpdateScreenArea(   //Text scrolling area
	        physbase(),//STScreen,
	        WND,
	        videoSegSrcX[3],
	        videoSegSrcY[3],
	        videoSegWidth[3],
	        videoSegHeight[3],
	        videoSegX[3],
	        videoSegY[3],
	        palette1,
	        pc1,
	        &oldChecksumB,
	        videoSegSize[3],
	        false);
	  };
	}
	//g_warning("olololol TUT %d", STBLTCount);
	SDL_UnlockSurface(destSurface);
	if (!noDirtyRect) {
    SDL_Rect moffaPjopp = DirtyRect;
    i32 x, y, w, h;
    x = moffaPjopp.x;
    y = moffaPjopp.y;
    w = moffaPjopp.w;
    h = moffaPjopp.h;
    //printf("updateRect(%d, %d)x(%d, %d)\n", x, y, w, h);
    SDL_UpdateRect(destSurface, x, y, w, h);
    noDirtyRect = TRUE;
	}
}
