#ifndef UTIL_H
#define UTIL_H

#include <QtNetwork/QTcpSocket>
#include <QFile>
#include <fstream>
#include <iostream>
#include <QVector>
#include <QImage>
#include <QColor>

using namespace std;

#define BUFFER_SIZE 4096

/* Function to keep waiting for data until the amount expected has been received, or until timeout occurs. char * must point to a buffer with enough space to fit */
bool RecvData(QTcpSocket * sock, char * buffer, int size, int timeout);

bool SendFileData(QTcpSocket * sock, QString filename);

bool SendBufferData(QTcpSocket * sock, char * buffer, int length);

void WriteToFile(char * data, char * filename, int length);

int LangToInt(QString lang);

QString IntToLang(int i);

QImage GloballyThreshold(QImage in, int t);

struct BoundingBoxCoords{
    int left;
    int top;
    int right;
    int bottom;

    BoundingBoxCoords() : left(0), top(0), right(0), bottom(0){};
    BoundingBoxCoords(int l, int t, int r, int b) : left(l), top(t), right(r), bottom(b){};

};

struct ResultChar{
    QList<QChar> alts;
    int selected_alt;
    int confidence;
    BoundingBoxCoords bounding_box;
    int src_text_start_pos;
    int src_text_end_pos;
};

class AdaptiveThresholder{
public:
    void Init(QImage img);

    QVector<QVector<quint64> > ComputeIntegralImage(bool squared);

    QImage AdaptivelyThreshold(int w, float bias = 1.0);

    quint64 getMean(int x, int y, int w);
    quint64 getVariance(int x, int y, int w);
    int getThresholdValue(int x, int y, int w, float k = 0.34);

private:
    QImage srcImg;
    QVector<QVector<quint64> > integralImg; // Column major form
    QVector<QVector<quint64> > squaredIntegralImg; // Column major form
};

#endif
