#ifndef HEN_H
#define HEN_H

#include <QPixmap>
#include <QGraphicsObject>
#include "common.h"

class Hen : public QGraphicsObject, public Touchable
{
    Q_OBJECT

public:

    Hen(Position position, bool is_livewallpaper);

    void paint ( QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget = 0 );

    QRectF boundingRect() const;

    Position position() const;

    void setPressed(bool pressed);

    void touchStarted();

    void touchEnded();

    void mousePressEvent(QGraphicsSceneMouseEvent *event);

    void mouseReleaseEvent(QGraphicsSceneMouseEvent *event);

    //void mouseMoveEvent(QGraphicsSceneMouseEvent *event);

signals:

    void touched( Position position);

private:

    Position mPosition;
    QPixmap mPixmap;
    QPixmap mPressedPixmap;
    bool mIsPressed;

    bool livewallpaper;
};

#endif // HEN_H
