#include "abscractscreen.h"
#include <QGraphicsScene>
#include <QGraphicsTextItem>
#include <QPainter>
#include "textbutton.h"
#include "roundrectbutton.h"
#include <QDebug>

AbscractScreen::AbscractScreen(QGraphicsScene* scene)
    :QGraphicsObject(0)
{
    scene->addItem( this );
    this->setZValue(1);
}

void AbscractScreen::paint ( QPainter * painter, const QStyleOptionGraphicsItem * /*option*/, QWidget * /*widget*/ )
{
    QColor bgColor( Qt::darkGray );
    bgColor.setAlpha( 220 );
    painter->fillRect(boundingRect(), bgColor);
}

QRectF AbscractScreen::boundingRect() const
{
    return QRect(0,0,800,480);
}

TextButton* AbscractScreen::createTextButton( const QString& buttonText, int buttonSize)
{
    TextButton* btn = new TextButton(buttonText,buttonSize);
    btn->setParent(this);
    btn->setZValue(1);
    this->scene()->addItem( btn );
    return btn;
}

RoundRectButton* AbscractScreen::createRoundRectButton( const QString& buttonText, int fontSize,int buttonWidth)
{
    RoundRectButton* btn = new RoundRectButton(buttonText,fontSize,buttonWidth);
    btn->setParent(this);
    btn->setZValue(1);
    this->scene()->addItem( btn );
    return btn;
}

QGraphicsTextItem* AbscractScreen::createTextItem(int fontSize,bool bold )
{
    QGraphicsTextItem* textItem = new QGraphicsTextItem(this);
    QFont font = textItem->font();
    font.setPointSize( font.pointSize() + fontSize);
    font.setBold(bold);
    textItem->setFont(font);
    textItem->setZValue(1);
    textItem->setDefaultTextColor(Qt::black);
    this->scene()->addItem( textItem);
    return textItem;
}
